/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest.nms;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import nl.rutgerkok.betterenderchest.BetterEnderChest;
import nl.rutgerkok.betterenderchest.BetterEnderInventoryHolder;
import nl.rutgerkok.betterenderchest.ChestRestrictions;
import nl.rutgerkok.betterenderchest.WorldGroup;
import nl.rutgerkok.betterenderchest.chestowner.ChestOwner;
import nl.rutgerkok.betterenderchest.io.SaveEntry;
import nl.rutgerkok.betterenderchest.nms.NMSHandler;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.json.simple.parser.JSONParser;

public class SimpleNMSHandler
extends NMSHandler {
    private static final int DATA_VERSION_MC_1_12_2 = 1343;
    private final BetterEnderChest plugin;

    public SimpleNMSHandler(BetterEnderChest plugin) {
        this.plugin = plugin;
    }

    @Override
    public void closeEnderChest(Location loc, Player player) {
        BlockPos blockPos = this.toBlockPosition(loc);
        BlockEntity tileEntity = ((CraftWorld)loc.getWorld()).getHandle().getBlockEntity(blockPos);
        if (tileEntity instanceof EnderChestBlockEntity) {
            EnderChestBlockEntity enderChest = (EnderChestBlockEntity)tileEntity;
            ServerPlayer serverPlayer = ((CraftPlayer)player).getHandle();
            serverPlayer.getEnderChestInventory().setActiveChest(null);
            enderChest.stopOpen((ContainerUser)serverPlayer);
        }
    }

    private int getDisabledSlots(CompoundTag baseTag) {
        return baseTag.getByteOr("DisabledSlots", (byte)0);
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    private int getRows(ChestOwner chestOwner, CompoundTag baseTag, ListTag inventoryListTag) {
        if (baseTag.contains("Rows")) {
            return baseTag.getByteOr("Rows", (byte)3);
        }
        int highestSlot = 0;
        for (int i = 0; i < inventoryListTag.size(); ++i) {
            highestSlot = Math.max(inventoryListTag.getCompoundOrEmpty(i).getByteOr("Slot", (byte)0) & 0xFF, highestSlot);
        }
        return Math.max((int)Math.ceil((double)highestSlot / 9.0), this.plugin.getEmptyInventoryProvider().getInventoryRows(chestOwner));
    }

    private int getStoredDataVersion(CompoundTag baseTag) {
        return baseTag.getIntOr("DataVersion", 1343);
    }

    @Override
    public boolean isAvailable() {
        try {
            Blocks.WHITE_WOOL.toString();
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private boolean isItemInsertionAllowed(CompoundTag baseTag) {
        return baseTag.getBooleanOr("ItemInsertion", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Inventory loadNBTInventoryFromFile(File file, ChestOwner chestOwner, WorldGroup worldGroup, String inventoryTagName) throws IOException {
        try (FileInputStream inputStream = null;){
            inputStream = new FileInputStream(file);
            CompoundTag baseTag = NbtIo.readCompressed((InputStream)inputStream, (NbtAccounter)NbtAccounter.unlimitedHeap());
            Inventory inventory = this.loadNBTInventoryFromTag(baseTag, chestOwner, worldGroup, inventoryTagName);
            return inventory;
        }
    }

    @Override
    public Inventory loadNBTInventoryFromJson(String jsonString, ChestOwner chestOwner, WorldGroup worldGroup) throws IOException {
        return this.loadNBTInventoryFromTag(JSONSimpleTypes.toTag(jsonString), chestOwner, worldGroup, "Inventory");
    }

    private Inventory loadNBTInventoryFromTag(CompoundTag baseTag, ChestOwner chestOwner, WorldGroup worldGroup, String inventoryTagName) throws IOException {
        ListTag inventoryTag = baseTag.getListOrEmpty(inventoryTagName);
        int inventoryRows = this.getRows(chestOwner, baseTag, inventoryTag);
        int disabledSlots = this.getDisabledSlots(baseTag);
        int dataVersion = this.getStoredDataVersion(baseTag);
        boolean itemInsertion = this.isItemInsertionAllowed(baseTag);
        ChestRestrictions chestRestrictions = new ChestRestrictions(inventoryRows, disabledSlots, itemInsertion);
        Inventory inventory = this.plugin.getEmptyInventoryProvider().loadEmptyInventory(chestOwner, worldGroup, chestRestrictions);
        ArrayList<ItemStack> overflowingItems = new ArrayList<ItemStack>();
        RegistryOps context = CraftRegistry.getMinecraftRegistry().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        for (int i = 0; i < inventoryTag.size(); ++i) {
            CompoundTag item = inventoryTag.getCompoundOrEmpty(i);
            int slot = item.getByteOr("Slot", (byte)0) & 0xFF;
            item = this.updateToLatestMinecraft(item, dataVersion);
            CraftItemStack bukkitItem = CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)((net.minecraft.world.item.ItemStack)net.minecraft.world.item.ItemStack.CODEC.parse((DynamicOps)context, (Object)item).getOrThrow()));
            if (slot < inventory.getSize()) {
                inventory.setItem(slot, (ItemStack)bukkitItem);
                continue;
            }
            overflowingItems.add((ItemStack)bukkitItem);
        }
        if (!overflowingItems.isEmpty()) {
            BetterEnderInventoryHolder.of(inventory).addOverflowingItems(overflowingItems);
        }
        BetterEnderInventoryHolder.of(inventory).markContentsAsSaved(inventory.getContents());
        return inventory;
    }

    @Override
    public void openEnderChest(Location loc, Player player) {
        BlockPos blockPos = this.toBlockPosition(loc);
        BlockEntity tileEntity = ((CraftWorld)loc.getWorld()).getHandle().getBlockEntity(blockPos);
        if (tileEntity instanceof EnderChestBlockEntity) {
            EnderChestBlockEntity enderChest = (EnderChestBlockEntity)tileEntity;
            ServerPlayer serverPlayer = ((CraftPlayer)player).getHandle();
            enderChest.startOpen((ContainerUser)serverPlayer);
            serverPlayer.getEnderChestInventory().setActiveChest(enderChest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveInventoryToFile(File file, SaveEntry saveEntry) throws IOException {
        OutputStream stream = null;
        try {
            file.getAbsoluteFile().getParentFile().mkdirs();
            file.createNewFile();
            stream = new FileOutputStream(file);
            NbtIo.writeCompressed((CompoundTag)this.saveInventoryToTag(saveEntry), (OutputStream)stream);
        }
        finally {
            if (stream != null) {
                stream.flush();
                ((FileOutputStream)stream).close();
            }
        }
    }

    @Override
    public String saveInventoryToJson(SaveEntry inventory) throws IOException {
        CompoundTag tag = this.saveInventoryToTag(inventory);
        return tag.toString();
    }

    private CompoundTag saveInventoryToTag(SaveEntry inventory) {
        CompoundTag baseTag = new CompoundTag();
        ListTag inventoryTag = new ListTag();
        int dataVersion = Bukkit.getUnsafe().getDataVersion();
        ChestRestrictions chestRestrictions = inventory.getChestRestrictions();
        baseTag.putByte("Rows", (byte)chestRestrictions.getChestRows());
        baseTag.putByte("DisabledSlots", (byte)chestRestrictions.getDisabledSlots());
        baseTag.putBoolean("ItemInsertion", chestRestrictions.isItemInsertionAllowed());
        baseTag.putString("OwnerName", inventory.getChestOwner().getDisplayName());
        baseTag.putInt("DataVersion", dataVersion);
        RegistryOps context = CraftRegistry.getMinecraftRegistry().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack == null || stack.getType() == Material.AIR) continue;
            CompoundTag item = (CompoundTag)net.minecraft.world.item.ItemStack.CODEC.encodeStart((DynamicOps)context, (Object)CraftItemStack.asNMSCopy((ItemStack)stack)).getOrThrow();
            item.putByte("Slot", (byte)i);
            inventoryTag.add((Object)item);
        }
        baseTag.put("Inventory", (Tag)inventoryTag);
        return baseTag;
    }

    private BlockPos toBlockPosition(Location location) {
        return new BlockPos(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    private CompoundTag updateToLatestMinecraft(CompoundTag item, int oldVersion) {
        int newVersion = Bukkit.getUnsafe().getDataVersion();
        Dynamic input = new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)item);
        Dynamic result = DataFixers.getDataFixer().update(References.ITEM_STACK, input, oldVersion, newVersion);
        return (CompoundTag)result.getValue();
    }

    static class JSONSimpleTypes {
        private static final String BYTE_ARRAY = "byteArray";

        JSONSimpleTypes() {
        }

        static Tag javaTypeToNBTTag(Object object) throws IOException {
            if (object instanceof Map) {
                Map map = (Map)object;
                Object byteArrayValue = map.get(BYTE_ARRAY);
                if (byteArrayValue instanceof List) {
                    List boxedBytes = (List)byteArrayValue;
                    return new ByteArrayTag(JSONSimpleTypes.unboxBytes(boxedBytes));
                }
                CompoundTag tag = new CompoundTag();
                for (Map.Entry entry : map.entrySet()) {
                    Tag value = JSONSimpleTypes.javaTypeToNBTTag(entry.getValue());
                    if (value == null) continue;
                    tag.put((String)entry.getKey(), value);
                }
                return tag;
            }
            if (object instanceof Number) {
                Number number = (Number)object;
                if (number instanceof Integer || number instanceof Long) {
                    if ((long)number.intValue() == number.longValue()) {
                        return IntTag.valueOf((int)number.intValue());
                    }
                    return LongTag.valueOf((long)number.longValue());
                }
                return DoubleTag.valueOf((double)number.doubleValue());
            }
            if (object instanceof String) {
                return StringTag.valueOf((String)((String)object));
            }
            if (object instanceof List) {
                List list = (List)object;
                ListTag listTag = new ListTag();
                if (list.isEmpty()) {
                    return null;
                }
                Object firstElement = list.get(0);
                if (firstElement instanceof Integer || firstElement instanceof Long) {
                    List intList = list;
                    return new IntArrayTag(JSONSimpleTypes.unboxIntegers(intList));
                }
                for (Object entry : list) {
                    Tag javaType = JSONSimpleTypes.javaTypeToNBTTag(entry);
                    if (javaType == null) continue;
                    listTag.add((Object)javaType);
                }
                return listTag;
            }
            if (object == null) {
                return null;
            }
            throw new IOException("Unknown object: (" + String.valueOf(object.getClass()) + ") " + String.valueOf(object));
        }

        static CompoundTag toTag(String jsonString) throws IOException {
            if (jsonString.startsWith("{\"")) {
                try {
                    return (CompoundTag)JSONSimpleTypes.javaTypeToNBTTag(new JSONParser().parse(jsonString));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                return TagParser.parseCompoundFully((String)jsonString);
            }
            catch (CommandSyntaxException e) {
                throw new IOException(e);
            }
        }

        private static byte[] unboxBytes(List<Number> boxed) {
            byte[] bytes = new byte[boxed.size()];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = boxed.get(i).byteValue();
            }
            return bytes;
        }

        private static final int[] unboxIntegers(List<Number> boxed) {
            int[] ints = new int[boxed.size()];
            for (int i = 0; i < ints.length; ++i) {
                ints[i] = boxed.get(i).intValue();
            }
            return ints;
        }
    }

    private static class TagType {
        private static final int COMPOUND = 10;

        private TagType() {
        }
    }
}

