/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest.io.file;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import nl.rutgerkok.betterenderchest.WorldGroup;
import nl.rutgerkok.betterenderchest.chestowner.ChestOwner;
import nl.rutgerkok.betterenderchest.exception.ChestNotFoundException;
import nl.rutgerkok.betterenderchest.io.ChestLoader;
import nl.rutgerkok.betterenderchest.io.ChestSaver;
import nl.rutgerkok.betterenderchest.io.SaveEntry;
import nl.rutgerkok.betterenderchest.nms.NMSHandler;
import org.bukkit.inventory.Inventory;

public final class BetterEnderFileHandler
implements ChestLoader,
ChestSaver {
    private static final String EXTENSION = ".dat";
    private final File chestFolder;
    private final NMSHandler nmsHandler;

    public BetterEnderFileHandler(NMSHandler nmsHandler, File chestFolder) {
        this.nmsHandler = (NMSHandler)Preconditions.checkNotNull((Object)nmsHandler, (Object)"nmsHandler");
        this.chestFolder = (File)Preconditions.checkNotNull((Object)chestFolder, (Object)"chestFolder");
    }

    private File getChestDirectory(WorldGroup worldGroup) {
        if (worldGroup.getGroupName().equals("default")) {
            return this.chestFolder;
        }
        return new File(this.chestFolder, worldGroup.getGroupName());
    }

    private File getChestFile(ChestOwner chestOwner, WorldGroup worldGroup) {
        File directory = this.getChestDirectory(worldGroup);
        return new File(directory, chestOwner.getSaveFileName() + EXTENSION);
    }

    @Override
    public Inventory loadInventory(ChestOwner chestOwner, WorldGroup worldGroup) throws ChestNotFoundException, IOException {
        File file = this.getChestFile(chestOwner, worldGroup);
        if (!file.exists()) {
            throw new ChestNotFoundException(chestOwner, worldGroup);
        }
        return this.nmsHandler.loadNBTInventoryFromFile(file, chestOwner, worldGroup, "Inventory");
    }

    @Override
    public void saveChest(SaveEntry saveEntry) throws IOException {
        File file = this.getChestFile(saveEntry.getChestOwner(), saveEntry.getWorldGroup());
        this.nmsHandler.saveInventoryToFile(file, saveEntry);
    }
}

