/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest.importers;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.ListIterator;
import nl.rutgerkok.betterenderchest.BetterEnderChest;
import nl.rutgerkok.betterenderchest.BetterEnderUtils;
import nl.rutgerkok.betterenderchest.WorldGroup;
import nl.rutgerkok.betterenderchest.chestowner.ChestOwner;
import nl.rutgerkok.betterenderchest.importers.InventoryImporter;
import nl.rutgerkok.betterenderchest.registry.Registration;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class VanillaImporter
extends InventoryImporter {
    @Override
    public String getName() {
        return "vanilla";
    }

    @Override
    public Registration.Priority getPriority() {
        return Registration.Priority.LOW;
    }

    @Override
    public Inventory importInventory(ChestOwner chestOwner, WorldGroup worldGroup, BetterEnderChest plugin) throws IOException {
        Inventory betterEnderInventory;
        if (chestOwner.isSpecialChest()) {
            return null;
        }
        Player player = chestOwner.getPlayer();
        if (player == null) {
            File playerDirectory = new File(((World)Bukkit.getWorlds().get(0)).getWorldFolder().getAbsolutePath() + "/playerdata");
            File playerFile = new File(playerDirectory.getAbsolutePath() + "/" + chestOwner.getSaveFileName() + ".dat");
            if (!playerFile.exists()) {
                return null;
            }
            betterEnderInventory = plugin.getNMSHandlers().getSelectedRegistration().loadNBTInventoryFromFile(playerFile, chestOwner, worldGroup, "EnderItems");
            if (betterEnderInventory == null) {
                return null;
            }
        } else {
            Inventory vanillaInventory = player.getEnderChest();
            int inventoryRows = plugin.getEmptyInventoryProvider().getInventoryRows(chestOwner, vanillaInventory);
            betterEnderInventory = plugin.getEmptyInventoryProvider().loadEmptyInventory(chestOwner, worldGroup, inventoryRows);
            ListIterator copyIterator = vanillaInventory.iterator();
            while (copyIterator.hasNext()) {
                int slot = copyIterator.nextIndex();
                ItemStack stack = (ItemStack)copyIterator.next();
                if (slot >= betterEnderInventory.getSize()) continue;
                betterEnderInventory.setItem(slot, stack);
            }
        }
        if (BetterEnderUtils.isInventoryEmpty(betterEnderInventory)) {
            return null;
        }
        return betterEnderInventory;
    }

    @Override
    public Iterable<WorldGroup> importWorldGroups(BetterEnderChest plugin) {
        HashSet<WorldGroup> worldGroups = new HashSet<WorldGroup>();
        WorldGroup standardGroup = new WorldGroup("default");
        standardGroup.setInventoryImporter(this);
        standardGroup.addWorlds(Bukkit.getWorlds());
        worldGroups.add(standardGroup);
        return worldGroups;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }
}

