/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest.chestowner;

import nl.rutgerkok.betterenderchest.Translations;
import nl.rutgerkok.betterenderchest.chestowner.ChestOwner;
import org.apache.commons.lang3.Validate;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public final class NamedChestOwner
implements ChestOwner {
    private final String name;

    public NamedChestOwner(String name) {
        Validate.notNull((Object)name, (String)"Name may not be null", (Object[])new Object[0]);
        this.name = name;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof NamedChestOwner)) {
            return false;
        }
        return ((NamedChestOwner)other).name.equalsIgnoreCase(this.name);
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public String getInventoryTitle() {
        return Translations.PRIVATE_CHEST_TITLE.toString(this.name);
    }

    @Override
    public OfflinePlayer getOfflinePlayer() {
        return Bukkit.getOfflinePlayer((String)this.name);
    }

    @Override
    public Player getPlayer() {
        return Bukkit.getPlayerExact((String)this.name);
    }

    @Override
    public String getSaveFileName() {
        return this.name.toLowerCase();
    }

    public int hashCode() {
        return this.name.toLowerCase().hashCode();
    }

    @Override
    public boolean isDefaultChest() {
        return false;
    }

    @Override
    public boolean isOwnerOnline() {
        return this.getPlayer() != null;
    }

    @Override
    public boolean isPlayer(OfflinePlayer player) {
        return this.name.equalsIgnoreCase(player.getName());
    }

    @Override
    public boolean isPublicChest() {
        return false;
    }

    @Override
    public boolean isSpecialChest() {
        return false;
    }
}

