/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest;

import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ListIterator;
import nl.rutgerkok.betterenderchest.BetterEnderChest;
import nl.rutgerkok.betterenderchest.BetterEnderInventoryHolder;
import nl.rutgerkok.betterenderchest.BetterEnderUtils;
import nl.rutgerkok.betterenderchest.ChestRestrictions;
import nl.rutgerkok.betterenderchest.WorldGroup;
import nl.rutgerkok.betterenderchest.chestowner.ChestOwner;
import nl.rutgerkok.betterenderchest.exception.ChestNotFoundException;
import org.bukkit.Bukkit;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class EmptyInventoryProvider {
    private final BetterEnderChest plugin;

    public EmptyInventoryProvider(BetterEnderChest plugin) {
        this.plugin = plugin;
    }

    private ListenableFuture<Inventory> getDefaultInventory(final ChestOwner chestOwner, final WorldGroup worldGroup) {
        if (chestOwner.equals(this.plugin.getChestOwners().defaultChest())) {
            return Futures.immediateFuture((Object)this.loadEmptyInventory(chestOwner, worldGroup));
        }
        ListenableFuture<Inventory> defaultInventory = this.plugin.getChestCache().getInventory(this.plugin.getChestOwners().defaultChest(), worldGroup);
        return Futures.transform(defaultInventory, (Function)new Function<Inventory, Inventory>(){

            public Inventory apply(Inventory defaultInventory) {
                Inventory playerInventory = EmptyInventoryProvider.this.loadEmptyInventory(chestOwner, worldGroup);
                BetterEnderUtils.copyContents(defaultInventory, playerInventory, null);
                return playerInventory;
            }
        }, Runnable::run);
    }

    public ListenableFuture<Inventory> getFallbackInventory(ChestOwner chestOwner, WorldGroup worldGroup) {
        ListenableFuture<Inventory> imported = worldGroup.getInventoryImporter().importInventoryAsync(chestOwner, worldGroup, this.plugin);
        return Futures.catchingAsync(imported, Throwable.class, t -> {
            if (t instanceof ChestNotFoundException) {
                return this.getDefaultInventory(chestOwner, worldGroup);
            }
            this.plugin.severe("Could not import inventory " + String.valueOf(chestOwner), (Throwable)t);
            return Futures.immediateFuture((Object)this.loadEmptyInventory(chestOwner, worldGroup));
        }, Runnable::run);
    }

    public int getInventoryRows(ChestOwner chestOwner) {
        if (chestOwner.isPublicChest()) {
            return this.plugin.getChestSizes().getPublicChestRows();
        }
        return this.plugin.getChestSizes().getDefaultChestRows();
    }

    public int getInventoryRows(ChestOwner chestOwner, Inventory contents) {
        return this.getInventoryRows(chestOwner, contents.iterator());
    }

    public int getInventoryRows(ChestOwner chestOwner, ListIterator<ItemStack> it) {
        int highestSlot = 0;
        while (it.hasNext()) {
            int currentSlot = it.nextIndex();
            ItemStack stack = it.next();
            if (stack == null) continue;
            highestSlot = Math.max(currentSlot, highestSlot);
        }
        return Math.max((int)Math.ceil((double)highestSlot / 9.0), this.getInventoryRows(chestOwner));
    }

    public Inventory loadEmptyInventory(ChestOwner chestOwner, WorldGroup worldGroup) {
        return this.loadEmptyInventory(chestOwner, worldGroup, this.getInventoryRows(chestOwner));
    }

    public Inventory loadEmptyInventory(ChestOwner chestOwner, WorldGroup worldGroup, ChestRestrictions chestRestrictions) {
        int inventoryRows = chestRestrictions.getChestRows();
        return Bukkit.createInventory((InventoryHolder)new BetterEnderInventoryHolder(chestOwner, worldGroup, chestRestrictions), (int)(inventoryRows * 9), (String)chestOwner.getTrimmedInventoryTitle());
    }

    public Inventory loadEmptyInventory(ChestOwner chestOwner, WorldGroup worldGroup, int rows) {
        ChestRestrictions restrictions = new ChestRestrictions(rows, 0, true);
        return this.loadEmptyInventory(chestOwner, worldGroup, restrictions);
    }
}

