/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest;

public final class ChestRestrictions {
    public static final int MAX_ROWS = 6;
    private final boolean allowItemInsertions;
    private final int chestRows;
    private final int disabledSlots;

    public ChestRestrictions(int chestRows, int disabledSlots, boolean allowItemInsertions) {
        if (chestRows > 6) {
            chestRows = 6;
        }
        this.chestRows = chestRows;
        this.disabledSlots = disabledSlots;
        this.allowItemInsertions = allowItemInsertions;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChestRestrictions other = (ChestRestrictions)obj;
        if (this.allowItemInsertions != other.allowItemInsertions) {
            return false;
        }
        if (this.chestRows != other.chestRows) {
            return false;
        }
        return this.disabledSlots == other.disabledSlots;
    }

    public int getChestRows() {
        return this.chestRows;
    }

    public int getDisabledSlots() {
        return this.disabledSlots;
    }

    public int getTakeOnlySlots() {
        if (!this.allowItemInsertions) {
            return this.chestRows * 9;
        }
        return this.disabledSlots;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.allowItemInsertions ? 1231 : 1237);
        result = 31 * result + this.chestRows;
        result = 31 * result + this.disabledSlots;
        return result;
    }

    public boolean isItemInsertionAllowed() {
        return this.allowItemInsertions;
    }
}

