/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest.io.mysql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import nl.rutgerkok.betterenderchest.WorldGroup;
import nl.rutgerkok.betterenderchest.chestowner.ChestOwner;
import nl.rutgerkok.betterenderchest.io.mysql.DatabaseSettings;

public final class SQLHandler {
    private static final String TABLE_NAME_PREFIX = "bec_chestdata_";
    private Connection connection;
    private final Object connectionLock = new Object();
    private final DatabaseSettings settings;

    public SQLHandler(DatabaseSettings settings) throws SQLException {
        this.settings = settings;
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            try {
                Class.forName("com.mysql.jdbc.Driver");
            }
            catch (ClassNotFoundException e1) {
                throw new SQLException("Failed to load Java database driver", e1);
            }
        }
        this.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChest(ChestOwner chestOwner, WorldGroup worldGroup, String json) throws SQLException {
        try (Statement statement = null;){
            String query = "INSERT INTO `" + this.getTableName(worldGroup) + "` (`chest_owner`, `chest_data`) ";
            query = query + "VALUES (?, ?)";
            statement = this.getConnection().prepareStatement(query);
            statement.setString(1, chestOwner.getSaveFileName());
            statement.setString(2, json);
            statement.executeUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeConnection() throws SQLException {
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createGroupTable(WorldGroup group) throws SQLException {
        try (Statement statement = this.getConnection().createStatement();){
            String query = this.settings.useUtf8() ? "CREATE TABLE IF NOT EXISTS `" + this.getTableName(group) + "` ( `chest_id` int(10) unsigned NOT NULL AUTO_INCREMENT, `chest_owner` char(36) CHARACTER SET utf8mb4 NOT NULL, `chest_data` mediumtext CHARACTER SET utf8mb4 NOT NULL, PRIMARY KEY (`chest_id`), UNIQUE KEY `chest_owner` (`chest_owner`) ) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4  COLLATE=utf8mb4_unicode_ci;" : "CREATE TABLE IF NOT EXISTS `" + this.getTableName(group) + "` ( `chest_id` int(10) unsigned NOT NULL AUTO_INCREMENT, `chest_owner` char(36) NOT NULL, `chest_data` mediumtext NOT NULL, PRIMARY KEY (`chest_id`), UNIQUE KEY `chest_owner` (`chest_owner`) ) ENGINE=InnoDB;";
            statement.execute(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection() throws SQLException {
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.connection != null && !this.connection.isClosed() && this.connection.isValid(1)) {
                return this.connection;
            }
            if (this.connection != null) {
                this.connection.close();
            }
            String connectionString = "jdbc:mysql://" + this.settings.getHost() + ":" + this.settings.getPort() + "/" + this.settings.getDatabaseName();
            if (this.settings.useUtf8()) {
                connectionString = connectionString + "?useUnicode=true&characterEncoding=UTF-8";
            }
            this.connection = DriverManager.getConnection(connectionString, this.settings.getUsername(), this.settings.getPassword());
            return this.connection;
        }
    }

    private String getTableName(WorldGroup group) {
        return TABLE_NAME_PREFIX + group.getGroupName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadChest(ChestOwner chestOwner, WorldGroup group) throws SQLException {
        Statement statement = null;
        ResultSet result = null;
        try {
            String query = "SELECT `chest_data` FROM `" + this.getTableName(group);
            query = query + "` WHERE `chest_owner` = ?";
            statement = this.getConnection().prepareStatement(query);
            statement.setString(1, chestOwner.getSaveFileName());
            result = statement.executeQuery();
            if (result.next()) {
                String string = result.getString("chest_data");
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (result != null) {
                result.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateChest(ChestOwner chestOwner, WorldGroup worldGroup, String json) throws SQLException {
        boolean performInsert = false;
        try (Statement statement = null;){
            String query = "UPDATE `" + this.getTableName(worldGroup) + "` SET `chest_data` = ? WHERE `chest_owner` = ?";
            statement = this.getConnection().prepareStatement(query);
            statement.setString(1, json);
            statement.setString(2, chestOwner.getSaveFileName());
            int changedRows = statement.executeUpdate();
            if (changedRows == 0) {
                performInsert = true;
            }
        }
        if (performInsert) {
            this.addChest(chestOwner, worldGroup, json);
        }
    }
}

