/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest.io.mysql;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.sql.SQLException;
import nl.rutgerkok.betterenderchest.WorldGroup;
import nl.rutgerkok.betterenderchest.chestowner.ChestOwner;
import nl.rutgerkok.betterenderchest.exception.ChestNotFoundException;
import nl.rutgerkok.betterenderchest.io.ChestLoader;
import nl.rutgerkok.betterenderchest.io.mysql.SQLHandler;
import nl.rutgerkok.betterenderchest.nms.NMSHandler;
import org.bukkit.inventory.Inventory;

final class SQLChestLoader
implements ChestLoader {
    private final NMSHandler nmsHandler;
    private final SQLHandler sqlHandler;

    public SQLChestLoader(SQLHandler sqlHandler, NMSHandler nmsHandler) {
        this.sqlHandler = (SQLHandler)Preconditions.checkNotNull((Object)sqlHandler);
        this.nmsHandler = (NMSHandler)Preconditions.checkNotNull((Object)nmsHandler);
    }

    @Override
    public Inventory loadInventory(ChestOwner chestOwner, WorldGroup worldGroup) throws ChestNotFoundException, IOException {
        try {
            String inventory = this.sqlHandler.loadChest(chestOwner, worldGroup);
            if (inventory == null) {
                throw new ChestNotFoundException(chestOwner, worldGroup);
            }
            return this.nmsHandler.loadNBTInventoryFromJson(inventory, chestOwner, worldGroup);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }
}

