/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest.importers;

import com.onarandombox.multiverseinventories.MultiverseInventories;
import com.onarandombox.multiverseinventories.profile.GlobalProfile;
import com.onarandombox.multiverseinventories.profile.PlayerProfile;
import com.onarandombox.multiverseinventories.profile.ProfileType;
import com.onarandombox.multiverseinventories.profile.ProfileTypes;
import com.onarandombox.multiverseinventories.share.Sharables;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import nl.rutgerkok.betterenderchest.BetterEnderChest;
import nl.rutgerkok.betterenderchest.WorldGroup;
import nl.rutgerkok.betterenderchest.chestowner.ChestOwner;
import nl.rutgerkok.betterenderchest.importers.InventoryImporter;
import nl.rutgerkok.betterenderchest.registry.Registration;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class MultiverseInventoriesImporter
extends InventoryImporter {
    @Override
    public String getName() {
        return "multiverse-inventories";
    }

    @Override
    public Registration.Priority getPriority() {
        return Registration.Priority.NORMAL;
    }

    @Override
    public Inventory importInventory(ChestOwner chestOwner, WorldGroup worldGroup, BetterEnderChest plugin) throws IOException {
        String groupName = worldGroup.getGroupName();
        OfflinePlayer offlinePlayer = chestOwner.getOfflinePlayer();
        if (offlinePlayer == null || chestOwner.isSpecialChest()) {
            return null;
        }
        MultiverseInventories multiverseInventories = (MultiverseInventories)Bukkit.getServer().getPluginManager().getPlugin("Multiverse-Inventories");
        com.onarandombox.multiverseinventories.WorldGroup group = null;
        List multiverseInventoriesGroups = multiverseInventories.getGroupManager().getGroups();
        for (com.onarandombox.multiverseinventories.WorldGroup aGroup : multiverseInventoriesGroups) {
            if (!aGroup.getName().equalsIgnoreCase(groupName)) continue;
            group = aGroup;
            break;
        }
        if (group == null) {
            plugin.warning("No matching Multiverse-Inventories group found for " + groupName + ". Cannot import " + chestOwner.getDisplayName() + ".");
            return null;
        }
        GlobalProfile globalProfile = multiverseInventories.getData().getGlobalProfile(offlinePlayer.getName(), offlinePlayer.getUniqueId());
        if (globalProfile == null) {
            plugin.debug("It seems that there is no data for " + chestOwner.getDisplayName() + ", so nothing can be imported.");
            return null;
        }
        if (globalProfile.getLastWorld() == null) {
            plugin.debug("It seems that the world of " + chestOwner.getDisplayName() + " is null, so nothing can be imported.");
            return null;
        }
        if (group.containsWorld(globalProfile.getLastWorld())) {
            return plugin.getInventoryImporters().getRegistration("vanilla").importInventory(chestOwner, worldGroup, plugin);
        }
        ProfileType profileType = multiverseInventories.getMVIConfig().isUsingGameModeProfiles() ? ProfileTypes.forGameMode((GameMode)Bukkit.getDefaultGameMode()) : ProfileTypes.SURVIVAL;
        PlayerProfile playerData = multiverseInventories.getGroupManager().getGroup(groupName).getGroupProfileContainer().getPlayerData(profileType, offlinePlayer);
        if (playerData == null) {
            return null;
        }
        ItemStack[] stacks = (ItemStack[])playerData.get(Sharables.ENDER_CHEST);
        if (stacks == null || stacks.length == 0) {
            return null;
        }
        Inventory betterInventory = plugin.getEmptyInventoryProvider().loadEmptyInventory(chestOwner, worldGroup);
        betterInventory.setContents(stacks);
        return betterInventory;
    }

    @Override
    public Iterable<WorldGroup> importWorldGroups(BetterEnderChest plugin) {
        HashSet<WorldGroup> becGroups = new HashSet<WorldGroup>();
        MultiverseInventories multiverseInventories = (MultiverseInventories)Bukkit.getServer().getPluginManager().getPlugin("Multiverse-Inventories");
        for (com.onarandombox.multiverseinventories.WorldGroup miGroup : multiverseInventories.getGroupManager().getGroups()) {
            WorldGroup worldGroup = new WorldGroup(miGroup.getName());
            worldGroup.setInventoryImporter(this);
            worldGroup.addWorlds(miGroup.getWorlds());
            becGroups.add(worldGroup);
        }
        return becGroups;
    }

    @Override
    public boolean isAvailable() {
        return Bukkit.getServer().getPluginManager().getPlugin("Multiverse-Inventories") != null;
    }
}

