/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest.importers;

import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.HashSet;
import java.util.concurrent.Callable;
import nl.rutgerkok.betterenderchest.BetterEnderChest;
import nl.rutgerkok.betterenderchest.WorldGroup;
import nl.rutgerkok.betterenderchest.chestowner.ChestOwner;
import nl.rutgerkok.betterenderchest.importers.InventoryImporter;
import nl.rutgerkok.betterenderchest.io.file.BetterEnderFileHandler;
import nl.rutgerkok.betterenderchest.nms.NMSHandler;
import nl.rutgerkok.betterenderchest.registry.Registration;
import org.bukkit.Bukkit;
import org.bukkit.inventory.Inventory;

public class BetterEnderFlatFileImporter
extends InventoryImporter {
    private final BetterEnderFileHandler fileHandler;

    public BetterEnderFlatFileImporter(BetterEnderChest plugin) {
        NMSHandler nms = plugin.getNMSHandlers().getSelectedRegistration();
        this.fileHandler = nms == null ? null : new BetterEnderFileHandler(nms, plugin.getChestSaveLocation());
    }

    @Override
    public String getName() {
        return "betterenderchest-flatfilenbt";
    }

    @Override
    public Registration.Priority getPriority() {
        return Registration.Priority.LOWEST;
    }

    @Override
    public ListenableFuture<Inventory> importInventoryAsync(final ChestOwner chestOwner, final WorldGroup worldGroup, BetterEnderChest plugin) {
        return plugin.getExecutors().workerThreadExecutor().submit(new Callable<Inventory>(){

            @Override
            public Inventory call() throws IOException {
                return BetterEnderFlatFileImporter.this.fileHandler.loadInventory(chestOwner, worldGroup);
            }
        });
    }

    @Override
    public Iterable<WorldGroup> importWorldGroups(BetterEnderChest plugin) {
        HashSet<WorldGroup> worldGroups = new HashSet<WorldGroup>();
        WorldGroup standardGroup = new WorldGroup("default");
        standardGroup.setInventoryImporter(this);
        standardGroup.addWorlds(Bukkit.getWorlds());
        worldGroups.add(standardGroup);
        return worldGroups;
    }

    @Override
    public boolean isAvailable() {
        return this.fileHandler != null;
    }
}

