/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest.command;

import java.util.List;
import nl.rutgerkok.betterenderchest.BetterEnderChest;
import nl.rutgerkok.betterenderchest.BetterEnderChestPlugin;
import nl.rutgerkok.betterenderchest.Translations;
import nl.rutgerkok.betterenderchest.WorldGroup;
import nl.rutgerkok.betterenderchest.chestowner.ChestOwner;
import nl.rutgerkok.betterenderchest.command.BaseCommand;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class OpenInvCommand
extends BaseCommand {
    public OpenInvCommand(BetterEnderChest plugin) {
        super(plugin);
    }

    @Override
    public List<String> autoComplete(CommandSender sender, String[] args) {
        if (args.length == 1 && sender.hasPermission("betterenderchest.command.openinv.other")) {
            return null;
        }
        return super.autoComplete(sender, args);
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + Translations.CONSOLE_ERROR.toString());
            return true;
        }
        if (!this.plugin.canSaveAndLoad()) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + Translations.ENDER_CHESTS_DISABLED.toString());
            this.plugin.printSaveAndLoadError();
            return true;
        }
        Player player = (Player)sender;
        String inventoryName = null;
        WorldGroup group = this.getGroup((CommandSender)player);
        if (args.length == 0) {
            ChestOwner chestOwner = BetterEnderChestPlugin.PublicChest.openOnUsingCommand ? this.plugin.getChestOwners().publicChest() : this.plugin.getChestOwners().playerChest(player);
            this.plugin.getChestCache().getInventory(chestOwner, group, this.plugin.getChestOpener().showInventory(player));
        } else {
            if (!player.hasPermission("betterenderchest.command.openinv")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + Translations.CAN_ONLY_OPEN_OWN_CHEST.toString());
                return true;
            }
            inventoryName = this.getInventoryName(args[0]);
            group = this.getGroup(args[0], sender);
            if (group == null) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + Translations.GROUP_NOT_FOUND.toString());
                return true;
            }
            this.getInventory(sender, inventoryName, group, this.plugin.getChestOpener().showInventory(player));
        }
        return true;
    }

    @Override
    public String getHelpText() {
        return Translations.OPEN_INV_HELP_TEXT.toString();
    }

    @Override
    public String getName() {
        return Translations.OPEN_INV_COMMAND.toString();
    }

    @Override
    public String getUsage() {
        return Translations.OPEN_INV_USAGE.toString();
    }

    @Override
    public boolean hasPermission(CommandSender sender) {
        return sender.hasPermission("betterenderchest.command.openinv.self");
    }
}

