/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest.command;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.HashMap;
import nl.rutgerkok.betterenderchest.BetterEnderChest;
import nl.rutgerkok.betterenderchest.Translations;
import nl.rutgerkok.betterenderchest.WorldGroup;
import nl.rutgerkok.betterenderchest.command.BaseCommand;
import nl.rutgerkok.betterenderchest.io.Consumer;
import nl.rutgerkok.betterenderchest.util.MaterialParser;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class GiveCommand
extends BaseCommand {
    private static final int MAX_COUNT = 3456;

    public GiveCommand(BetterEnderChest plugin) {
        super(plugin);
    }

    private void addItem(final CommandSender sender, final String inventoryName, WorldGroup group, final ItemStack stack, final int amount) {
        this.getInventory(sender, inventoryName, group, new Consumer<Inventory>(){

            @Override
            public void consume(Inventory inventory) {
                int remainingAmount;
                int addCount;
                for (remainingAmount = amount; remainingAmount > 0; remainingAmount -= addCount) {
                    ItemStack add = stack.clone();
                    addCount = Math.min(add.getMaxStackSize(), remainingAmount);
                    add.setAmount(addCount);
                    HashMap overflow = inventory.addItem(new ItemStack[]{add});
                    if (overflow.isEmpty()) continue;
                    int didntAdd = ((ItemStack)overflow.values().iterator().next()).getAmount();
                    remainingAmount += didntAdd;
                    break;
                }
                GiveCommand.this.sendItemAddedMessage(sender, inventoryName, amount, remainingAmount);
            }
        });
    }

    private ItemStack addNBT(ItemStack stack, String nbt) throws Throwable {
        return Bukkit.getUnsafe().modifyItemStack(stack, nbt);
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        Material material;
        if (args.length < 2) {
            return false;
        }
        String inventoryName = this.getInventoryName(args[0]);
        WorldGroup group = this.getGroup(args[0], sender);
        if (group == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + Translations.GROUP_NOT_FOUND.toString(args[0]));
        }
        String materialAndCount = Joiner.on((char)' ').join(Arrays.asList(args).subList(1, args.length));
        int startBrace = materialAndCount.indexOf(123);
        int endBrace = materialAndCount.lastIndexOf(125);
        String materialName = null;
        String nbt = null;
        String countString = null;
        if (startBrace == -1) {
            if (endBrace != -1) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + Translations.GIVE_FAILED_READ_MATERIAL_AMOUNT_EXTRA_BRACE.toString(materialAndCount));
                return true;
            }
            materialName = args[1];
            if (args.length >= 3) {
                countString = args[2];
            }
        } else {
            if (endBrace == -1) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + Translations.GIVE_FAILED_READ_MATERIAL_AMOUNT_MISSING_BRACE.toString(materialAndCount));
                return true;
            }
            materialName = materialAndCount.substring(0, startBrace);
            nbt = materialAndCount.substring(startBrace, endBrace + 1);
            if (endBrace + 1 < materialAndCount.length()) {
                countString = materialAndCount.substring(endBrace + 1).trim();
            }
        }
        if ((material = MaterialParser.matchMaterial(materialName)) == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + Translations.GIVE_INVALID_MATERIAL.toString(args[1]));
            return true;
        }
        int count = 1;
        if (countString != null) {
            try {
                count = Integer.parseInt(countString);
                if (count > 3456) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + Translations.GIVE_AMOUNT_CAPPED.toString(3456));
                    count = 3456;
                }
            }
            catch (NumberFormatException e) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + countString + " " + Translations.GIVE_INVALID_AMOUNT.toString());
                return true;
            }
        }
        ItemStack stack = new ItemStack(material, 1);
        if (nbt != null) {
            try {
                stack = this.addNBT(stack, nbt);
            }
            catch (Throwable t) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + Translations.GIVE_FAILED_SET_NBT_TAG.toString(String.valueOf(ChatColor.WHITE) + nbt + String.valueOf(ChatColor.RED)));
                return true;
            }
        }
        this.addItem(sender, inventoryName, group, stack, count);
        return true;
    }

    @Override
    public String getHelpText() {
        return Translations.GIVE_HELP_TEXT.toString();
    }

    @Override
    public String getName() {
        return Translations.GIVE_COMMAND.toString();
    }

    @Override
    public String getUsage() {
        return Translations.GIVE_USAGE.toString();
    }

    private void sendItemAddedMessage(CommandSender sender, String inventoryName, int totalAmount, int remainingAmount) {
        if (remainingAmount == 0) {
            if (totalAmount == 1) {
                sender.sendMessage(Translations.GIVE_ITEM_ADDED_SINGLE.toString(inventoryName));
            } else {
                sender.sendMessage(Translations.GIVE_ITEM_ADDED_MULTIPLE.toString(inventoryName));
            }
        } else if (remainingAmount == totalAmount) {
            if (totalAmount == 1) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + Translations.GIVE_ITEM_NOT_ADDED_SINGLE_FULL.toString(inventoryName));
            } else {
                sender.sendMessage(String.valueOf(ChatColor.RED) + Translations.GIVE_ITEMS_NOT_ADDED_FULL.toString(inventoryName));
            }
        } else if (remainingAmount == 1) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + Translations.GIVE_ITEM_NOT_ADDED_SINGLE.toString(inventoryName));
        } else {
            sender.sendMessage(String.valueOf(ChatColor.RED) + Translations.GIVE_ITEMS_NOT_ADDED.toString(remainingAmount, inventoryName));
        }
    }
}

