/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import nl.rutgerkok.betterenderchest.BetterEnderChest;
import nl.rutgerkok.betterenderchest.Translations;
import nl.rutgerkok.betterenderchest.command.BaseCommand;
import nl.rutgerkok.betterenderchest.command.DeleteInvCommand;
import nl.rutgerkok.betterenderchest.command.GiveCommand;
import nl.rutgerkok.betterenderchest.command.ListCommand;
import nl.rutgerkok.betterenderchest.command.OpenInvCommand;
import nl.rutgerkok.betterenderchest.command.ReloadCommand;
import nl.rutgerkok.betterenderchest.command.SwapInvCommand;
import nl.rutgerkok.betterenderchest.command.ViewInvCommand;
import nl.rutgerkok.betterenderchest.registry.Registry;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.util.StringUtil;

public class BetterEnderCommandManager
implements TabExecutor {
    private BetterEnderChest plugin;

    public BetterEnderCommandManager(BetterEnderChest plugin) {
        this.plugin = plugin;
        Registry<BaseCommand> commands = plugin.getCommands();
        commands.register(new DeleteInvCommand(plugin));
        commands.register(new GiveCommand(plugin));
        commands.register(new ListCommand(plugin));
        commands.register(new OpenInvCommand(plugin));
        commands.register(new ReloadCommand(plugin));
        commands.register(new SwapInvCommand(plugin));
        commands.register(new ViewInvCommand(plugin));
    }

    public boolean onCommand(CommandSender sender, Command bukkitCommand, String label, String[] originalArgs) {
        if (originalArgs.length == 0) {
            this.showHelp(sender, label);
            return true;
        }
        String name = originalArgs[0];
        String[] args = new String[originalArgs.length - 1];
        for (int i = 1; i < originalArgs.length; ++i) {
            args[i - 1] = originalArgs[i];
        }
        BaseCommand command = this.plugin.getCommands().getRegistration(originalArgs[0]);
        if (command == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + Translations.COMMAND_MANAGER_COMMAND_NOT_FOUND.toString(name));
            this.showHelp(sender, label);
            return true;
        }
        if (!command.hasPermission(sender)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + Translations.NO_PERMISSION.toString());
            return true;
        }
        if (!command.execute(sender, args)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + Translations.COMMAND_MANAGER_WRONG_COMMAND_USAGE.toString());
            sender.sendMessage(String.valueOf(ChatColor.RED) + "/" + label + " " + name + " " + command.getUsage());
            return true;
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] originalArgs) {
        BaseCommand baseCommand;
        if (originalArgs.length == 1) {
            ArrayList<String> matches = new ArrayList<String>();
            for (BaseCommand baseCommand2 : this.plugin.getCommands().getRegistrations()) {
                if (!StringUtil.startsWithIgnoreCase((String)baseCommand2.getName(), (String)originalArgs[0]) || !baseCommand2.hasPermission(sender)) continue;
                matches.add(baseCommand2.getName());
            }
            return matches;
        }
        if (originalArgs.length > 1 && (baseCommand = this.plugin.getCommands().getRegistration(originalArgs[0])) != null && baseCommand.hasPermission(sender)) {
            String[] args = new String[originalArgs.length - 1];
            System.arraycopy(originalArgs, 1, args, 0, originalArgs.length - 1);
            return baseCommand.autoComplete(sender, args);
        }
        return Collections.emptyList();
    }

    private void showHelp(CommandSender sender, String label) {
        Collection<BaseCommand> commands = this.plugin.getCommands().getRegistrations();
        int commandCount = 0;
        for (BaseCommand command : commands) {
            if (!command.hasPermission(sender)) continue;
            if (!command.getUsage().equals("")) {
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "/" + label + " " + command.getName() + " " + command.getUsage() + ": " + String.valueOf(ChatColor.WHITE) + command.getHelpText());
            } else {
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "/" + label + " " + command.getName() + ": " + String.valueOf(ChatColor.WHITE) + command.getHelpText());
            }
            ++commandCount;
        }
        if (commandCount == 0) {
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + Translations.COMMAND_MANAGER_NO_AVAILABLE_COMMANDS.toString());
        }
    }
}

