/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest.command;

import java.util.Collections;
import java.util.List;
import nl.rutgerkok.betterenderchest.BetterEnderChest;
import nl.rutgerkok.betterenderchest.Translations;
import nl.rutgerkok.betterenderchest.WorldGroup;
import nl.rutgerkok.betterenderchest.chestowner.ChestOwner;
import nl.rutgerkok.betterenderchest.exception.InvalidOwnerException;
import nl.rutgerkok.betterenderchest.io.Consumer;
import nl.rutgerkok.betterenderchest.registry.Registration;
import org.bukkit.ChatColor;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public abstract class BaseCommand
implements Registration {
    protected BetterEnderChest plugin;

    public BaseCommand(BetterEnderChest plugin) {
        this.plugin = plugin;
    }

    public List<String> autoComplete(CommandSender sender, String[] args) {
        return Collections.emptyList();
    }

    public abstract boolean execute(CommandSender var1, String[] var2);

    protected WorldGroup getGroup(CommandSender sender) {
        if (sender instanceof Player) {
            return this.plugin.getWorldGroupManager().getGroupByWorld(((Player)sender).getWorld());
        }
        if (sender instanceof BlockCommandSender) {
            return this.plugin.getWorldGroupManager().getGroupByWorld(((BlockCommandSender)sender).getBlock().getWorld());
        }
        WorldGroup standardGroup = this.plugin.getWorldGroupManager().getStandardWorldGroup();
        if (standardGroup.hasWorlds()) {
            return standardGroup;
        }
        return null;
    }

    protected WorldGroup getGroup(String inventoryName, CommandSender sender) {
        String[] parts = inventoryName.split("/");
        if (parts.length == 2) {
            return this.plugin.getWorldGroupManager().getGroupByGroupName(parts[0]);
        }
        return this.getGroup(sender);
    }

    public abstract String getHelpText();

    protected void getInventory(final CommandSender sender, final String inventoryName, final WorldGroup worldGroup, final Consumer<Inventory> callback) {
        this.plugin.getChestOwners().fromInput(inventoryName, new Consumer<ChestOwner>(){

            @Override
            public void consume(ChestOwner chestOwner) {
                BaseCommand.this.plugin.getChestCache().getInventory(chestOwner, worldGroup, callback);
            }
        }, new Consumer<InvalidOwnerException>(){

            @Override
            public void consume(InvalidOwnerException t) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + Translations.PLAYER_NOT_SEEN_ON_SERVER.toString(inventoryName));
            }
        });
    }

    protected String getInventoryName(String inventoryName) {
        String[] parts = inventoryName.split("/");
        if (parts.length == 2) {
            return parts[1];
        }
        return parts[0];
    }

    @Override
    public Registration.Priority getPriority() {
        return Registration.Priority.NORMAL;
    }

    public abstract String getUsage();

    public boolean hasPermission(CommandSender sender) {
        return sender.hasPermission("betterenderchest.command." + this.getName());
    }

    @Override
    public boolean isAvailable() {
        return true;
    }
}

