/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest.chestprotection;

import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Protection;
import java.lang.reflect.Method;
import java.util.UUID;
import nl.rutgerkok.betterenderchest.BetterEnderChest;
import nl.rutgerkok.betterenderchest.chestowner.ChestOwner;
import nl.rutgerkok.betterenderchest.chestprotection.ProtectionBridge;
import nl.rutgerkok.betterenderchest.registry.Registration;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class LWCBridge
extends ProtectionBridge {
    private Method playerInfoGetNameMethod;
    private Method playerInfoGetUUIDMethod;
    private final BetterEnderChest plugin;
    private Method protectionGetOwnerMethod;

    public LWCBridge(BetterEnderChest plugin) {
        this.plugin = plugin;
        try {
            this.protectionGetOwnerMethod = Protection.class.getMethod("getOwner", new Class[0]);
            Class<?> returnType = this.protectionGetOwnerMethod.getReturnType();
            if (returnType.getName().equals("com.griefcraft.model.PlayerInfo")) {
                this.playerInfoGetNameMethod = returnType.getMethod("getName", new Class[0]);
                this.playerInfoGetUUIDMethod = returnType.getMethod("getUUID", new Class[0]);
            }
        }
        catch (NoClassDefFoundError returnType) {
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean canAccess(Player player, Block block) {
        return LWC.getInstance().canAccessProtection(player, block);
    }

    @Override
    public ChestOwner getChestOwner(Block block) throws IllegalArgumentException {
        Protection protection = LWC.getInstance().findProtection(block);
        return this.getOwnerFromProtection(protection);
    }

    @Override
    public String getName() {
        return "LWC";
    }

    private ChestOwner getOwnerFromProtection(Protection protection) {
        try {
            Object owner = this.protectionGetOwnerMethod.invoke((Object)protection, new Object[0]);
            if (owner instanceof String) {
                return this.getOwnerFromUUIDString((String)owner);
            }
            String name = (String)this.playerInfoGetNameMethod.invoke(owner, new Object[0]);
            UUID uuid = (UUID)this.playerInfoGetUUIDMethod.invoke(owner, new Object[0]);
            if (uuid == null) {
                return null;
            }
            return this.plugin.getChestOwners().playerChest(name, uuid);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ChestOwner getOwnerFromUUIDString(String string) {
        if (string.length() == 36) {
            try {
                UUID uuid = UUID.fromString(string);
                String ownerName = Bukkit.getOfflinePlayer((UUID)uuid).getName();
                if (ownerName == null) {
                    ownerName = "**unknown**";
                }
                return this.plugin.getChestOwners().playerChest(ownerName, uuid);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getOwnerName(Block block) {
        Protection protection = LWC.getInstance().findProtection(block);
        try {
            Object owner = this.protectionGetOwnerMethod.invoke((Object)protection, new Object[0]);
            if (owner instanceof String) {
                return (String)owner;
            }
            return (String)this.playerInfoGetNameMethod.invoke(owner, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Registration.Priority getPriority() {
        return Registration.Priority.NORMAL;
    }

    @Override
    public boolean isAvailable() {
        return this.protectionGetOwnerMethod != null;
    }

    @Override
    public boolean isProtected(Block block) {
        LWC lwc = LWC.getInstance();
        Protection protection = lwc.findProtection(block);
        if (protection == null) {
            return false;
        }
        return protection.getBlock().equals((Object)block);
    }
}

