/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest.chestowner;

import nl.rutgerkok.betterenderchest.Translations;
import nl.rutgerkok.betterenderchest.chestowner.ChestOwner;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

final class SpecialChestOwner
implements ChestOwner {
    static final String DEFAULT_CHEST_NAME = "--defaultchest";
    static final ChestOwner DEFAULT_CHEST_OWNER = new SpecialChestOwner("--defaultchest");
    static final String PUBLIC_CHEST_NAME = "--publicchest";
    static final ChestOwner PUBLIC_CHEST_OWNER = new SpecialChestOwner("--publicchest");
    private final String ownerName;

    private SpecialChestOwner(String ownerName) {
        this.ownerName = ownerName;
    }

    @Override
    public String getDisplayName() {
        return this.ownerName;
    }

    @Override
    public String getInventoryTitle() {
        if (this.isPublicChest()) {
            return Translations.PUBLIC_CHEST_TITLE.toString();
        }
        return Translations.DEFAULT_CHEST_TITLE.toString();
    }

    @Override
    public OfflinePlayer getOfflinePlayer() {
        return null;
    }

    @Override
    public Player getPlayer() {
        return null;
    }

    @Override
    public String getSaveFileName() {
        return this.ownerName;
    }

    @Override
    public boolean isDefaultChest() {
        return this == DEFAULT_CHEST_OWNER;
    }

    @Override
    public boolean isOwnerOnline() {
        return true;
    }

    @Override
    public boolean isPlayer(OfflinePlayer player) {
        return false;
    }

    @Override
    public boolean isPublicChest() {
        return this == PUBLIC_CHEST_OWNER;
    }

    @Override
    public boolean isSpecialChest() {
        return true;
    }

    public String toString() {
        return Translations.SPECIAL_CHEST_NAME.toString(this.ownerName);
    }
}

