/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nl.rutgerkok.betterenderchest.importers.InventoryImporter;
import nl.rutgerkok.betterenderchest.importers.NoneImporter;
import org.bukkit.World;

public class WorldGroup {
    private final String groupName;
    private InventoryImporter inventoryImporter;
    private Set<String> worlds = new HashSet<String>();

    public WorldGroup(String groupName) {
        this.inventoryImporter = new NoneImporter();
        if (this.inventoryImporter == null) {
            throw new RuntimeException("No fallback importer found! Please report! This is a bug!");
        }
        this.groupName = groupName.toLowerCase();
    }

    public void addWorld(String worldName) {
        this.worlds.add(worldName.toLowerCase());
    }

    public void addWorld(World world) {
        this.addWorld(world.getName());
    }

    public void addWorlds(Iterable<?> worlds) {
        for (Object world : worlds) {
            if (world instanceof World) {
                this.addWorld((World)world);
                continue;
            }
            if (world instanceof String) {
                this.addWorld((String)world);
                continue;
            }
            throw new IllegalArgumentException("addWorlds only accepts Iterable<String> and Iterable<World>");
        }
    }

    public boolean equals(Object otherObject) {
        return otherObject instanceof WorldGroup && ((WorldGroup)otherObject).groupName.equals(this.groupName);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public InventoryImporter getInventoryImporter() {
        return this.inventoryImporter;
    }

    public List<String> getWorldNames() {
        return new ArrayList<String>(this.worlds);
    }

    public int hashCode() {
        return (this.groupName.hashCode() + 1) * 2;
    }

    public boolean hasWorlds() {
        return this.worlds.size() > 0;
    }

    public boolean isWorldInGroup(String worldName) {
        return this.worlds.contains(worldName.toLowerCase());
    }

    public boolean isWorldInGroup(World world) {
        return this.isWorldInGroup(world.getName());
    }

    public void setInventoryImporter(InventoryImporter inventoryImporter) {
        if (inventoryImporter == null) {
            throw new IllegalArgumentException("InventoryImporter cannot be null!");
        }
        this.inventoryImporter = inventoryImporter;
    }
}

