/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import nl.rutgerkok.betterenderchest.BetterEnderUtils;
import nl.rutgerkok.betterenderchest.ChestRestrictions;
import nl.rutgerkok.betterenderchest.WorldGroup;
import nl.rutgerkok.betterenderchest.chestowner.ChestOwner;
import org.apache.commons.lang3.Validate;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class BetterEnderInventoryHolder
implements InventoryHolder {
    private final ChestOwner chestOwner;
    private int savedItemsHashCode = 0;
    private final ChestRestrictions chestRestrictions;
    private final ReentrantLock saveLock;
    private final WorldGroup worldGroup;
    private List<ItemStack> overflowingItems;

    public static BetterEnderInventoryHolder of(Inventory inventory) throws IllegalArgumentException {
        Preconditions.checkArgument((boolean)(inventory.getHolder() instanceof BetterEnderInventoryHolder), (Object)"not an Ender inventory");
        return (BetterEnderInventoryHolder)inventory.getHolder();
    }

    public BetterEnderInventoryHolder(ChestOwner chestOwner, WorldGroup worldGroup, ChestRestrictions chestRestrictions) throws IllegalArgumentException {
        Validate.notNull((Object)chestOwner, (String)"chestOwner may not be null", (Object[])new Object[0]);
        Validate.notNull((Object)worldGroup, (String)"worldGroup may not be null", (Object[])new Object[0]);
        Validate.notNull((Object)chestRestrictions, (String)"chestRestrictiosn may not be null", (Object[])new Object[0]);
        this.chestOwner = chestOwner;
        this.chestRestrictions = chestRestrictions;
        this.worldGroup = worldGroup;
        this.saveLock = new ReentrantLock();
        this.overflowingItems = new CopyOnWriteArrayList<ItemStack>();
    }

    public void addOverflowingItems(Collection<ItemStack> overflowingItems) {
        this.overflowingItems.addAll(overflowingItems);
    }

    public ChestOwner getChestOwner() {
        return this.chestOwner;
    }

    public ChestRestrictions getChestRestrictions() {
        return this.chestRestrictions;
    }

    @Deprecated
    public Inventory getInventory() {
        throw new UnsupportedOperationException();
    }

    public Lock getSaveLock() {
        return this.saveLock;
    }

    public int getTakeOnlySlots() {
        return this.chestRestrictions.getTakeOnlySlots();
    }

    public WorldGroup getWorldGroup() {
        return this.worldGroup;
    }

    public List<ItemStack> handleOverflowingItems() {
        List<ItemStack> overflow = this.overflowingItems;
        this.overflowingItems = new CopyOnWriteArrayList<ItemStack>();
        return overflow;
    }

    public boolean hasOverflowingItems() {
        return !this.overflowingItems.isEmpty();
    }

    public boolean hasUnsavedChanges(ItemStack[] currentContents) {
        return BetterEnderUtils.inventoryHashCode(currentContents) != this.savedItemsHashCode;
    }

    public void markContentsAsSaved(ItemStack[] contents) {
        this.savedItemsHashCode = BetterEnderUtils.inventoryHashCode(contents);
    }
}

