/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest.registry;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import nl.rutgerkok.betterenderchest.registry.Registration;
import org.apache.commons.lang3.Validate;

public class Registry<T extends Registration> {
    private Map<String, T> registered = new HashMap<String, T>();
    private T selected;
    private boolean selectedIsInited;

    private String filterName(String string) {
        return string.toLowerCase().replace("-", "").replace("_", "").replace(" ", "");
    }

    public T getAvailableRegistration(String name) {
        Registration registration = (Registration)this.registered.get(this.filterName(name));
        if (registration != null && registration.isAvailable()) {
            return (T)registration;
        }
        return null;
    }

    public T getRegistration(String name) {
        return (T)((Registration)this.registered.get(this.filterName(name)));
    }

    public Collection<T> getRegistrations() {
        return Collections.unmodifiableCollection(this.registered.values());
    }

    public T getSelectedRegistration() {
        if (!this.selectedIsInited) {
            throw new RuntimeException("Cannot retrieve selected registration: no registration has been selected!");
        }
        return this.selected;
    }

    public void register(T registration) {
        Validate.notNull(registration, (String)"Null registrations are not accepted", (Object[])new Object[0]);
        this.registered.put(this.filterName(registration.getName()), registration);
    }

    public T selectAvailableRegistration() {
        this.selectedIsInited = true;
        Registration selectedHigh = null;
        Registration selectedNormal = null;
        Registration selectedLow = null;
        Registration selectedFallback = null;
        for (Registration registration : this.registered.values()) {
            if (!registration.isAvailable()) continue;
            switch (registration.getPriority()) {
                case LOWEST: {
                    selectedFallback = registration;
                    break;
                }
                case HIGH: {
                    selectedHigh = registration;
                    break;
                }
                case LOW: {
                    selectedLow = registration;
                    break;
                }
                case NORMAL: {
                    selectedNormal = registration;
                }
            }
        }
        if (selectedHigh != null) {
            this.selected = selectedHigh;
            return this.selected;
        }
        if (selectedNormal != null) {
            this.selected = selectedNormal;
            return this.selected;
        }
        if (selectedLow != null) {
            this.selected = selectedLow;
            return this.selected;
        }
        if (selectedFallback != null) {
            this.selected = selectedFallback;
            return this.selected;
        }
        return this.selected;
    }

    public T selectAvailableRegistration(String name) {
        this.selectedIsInited = true;
        this.selected = this.getAvailableRegistration(name);
        return this.selected;
    }

    public T selectRegistration(T registration) {
        this.selectedIsInited = true;
        if (registration != null && !this.registered.containsValue(registration)) {
            this.register(registration);
        }
        this.selected = registration;
        return this.selected;
    }
}

