/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest.itemfilter;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

final class LoreFilter
implements Predicate<ItemStack> {
    private final Pattern pattern;
    private final boolean ignoreColors;

    public LoreFilter(Pattern pattern, boolean ignoreColors) {
        this.pattern = (Pattern)Preconditions.checkNotNull((Object)pattern, (Object)"pattern");
        this.ignoreColors = ignoreColors;
    }

    public boolean apply(ItemStack stack) {
        ItemMeta meta;
        if (stack.hasItemMeta() && (meta = stack.getItemMeta()).hasLore()) {
            String lore = Joiner.on((char)'\n').join((Iterable)stack.getItemMeta().getLore());
            if (this.ignoreColors) {
                lore = ChatColor.stripColor((String)lore);
            }
            return this.pattern.matcher(lore).find();
        }
        return false;
    }
}

