/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest.io;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.concurrent.Executor;
import nl.rutgerkok.betterenderchest.BetterEnderChest;
import nl.rutgerkok.betterenderchest.BetterEnderUtils;
import nl.rutgerkok.betterenderchest.WorldGroup;
import nl.rutgerkok.betterenderchest.chestowner.ChestOwner;
import nl.rutgerkok.betterenderchest.exception.ChestNotFoundException;
import nl.rutgerkok.betterenderchest.importers.InventoryImporter;
import nl.rutgerkok.betterenderchest.io.ChestLoader;
import nl.rutgerkok.betterenderchest.util.BukkitExecutors;
import nl.rutgerkok.betterenderchest.util.UpdateableFuture;
import org.bukkit.inventory.Inventory;

final class ChestLoadLogic {
    private final ChestLoader chestLoader;
    private final InventoryImporter importer;
    private final AsyncFunction<Throwable, Inventory> loadDefaultOnChestNotFound = new AsyncFunction<Throwable, Inventory>(){

        public ListenableFuture<Inventory> apply(Throwable t) throws IOException {
            if (t instanceof ChestNotFoundException) {
                ChestNotFoundException chestNotFound = (ChestNotFoundException)t;
                ChestOwner chestOwner = chestNotFound.getChestOwner();
                WorldGroup worldGroup = chestNotFound.getWorldGroup();
                Inventory newInventory = ChestLoadLogic.this.plugin.getEmptyInventoryProvider().loadEmptyInventory(chestOwner, worldGroup);
                try {
                    Inventory defaultInventory = ChestLoadLogic.this.chestLoader.loadInventory(ChestLoadLogic.this.plugin.getChestOwners().defaultChest(), worldGroup);
                    BetterEnderUtils.copyContents(defaultInventory, newInventory, null);
                }
                catch (ChestNotFoundException chestNotFoundException) {
                    // empty catch block
                }
                return Futures.immediateFuture((Object)newInventory);
            }
            return Futures.immediateFailedFuture((Throwable)t);
        }
    };
    private final BetterEnderChest plugin;

    public ChestLoadLogic(BetterEnderChest plugin, ChestLoader chestLoader) {
        this.plugin = (BetterEnderChest)Preconditions.checkNotNull((Object)plugin, (Object)"plugin");
        this.chestLoader = (ChestLoader)Preconditions.checkNotNull((Object)chestLoader, (Object)"chestLoader");
        this.importer = plugin.getInventoryImporters().getSelectedRegistration();
    }

    public ListenableFuture<Inventory> loadInventory(final ChestOwner chestOwner, final WorldGroup worldGroup) {
        final UpdateableFuture inventory = UpdateableFuture.create();
        final BukkitExecutors.BukkitExecutor worker = this.plugin.getExecutors().workerThreadExecutor();
        worker.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    inventory.set(ChestLoadLogic.this.chestLoader.loadInventory(chestOwner, worldGroup));
                }
                catch (ChestNotFoundException e) {
                    ListenableFuture<Inventory> imported = ChestLoadLogic.this.importer.importInventoryAsync(chestOwner, worldGroup, ChestLoadLogic.this.plugin);
                    ListenableFuture importedOrDefault = Futures.catchingAsync(imported, Throwable.class, ChestLoadLogic.this.loadDefaultOnChestNotFound, (Executor)worker);
                    inventory.updateUsing(importedOrDefault);
                }
                catch (IOException e) {
                    inventory.setException(e);
                }
            }
        });
        return inventory;
    }
}

