/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest.importers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import me.drayshak.WorldInventories.Group;
import me.drayshak.WorldInventories.WorldInventories;
import nl.rutgerkok.betterenderchest.BetterEnderChest;
import nl.rutgerkok.betterenderchest.WorldGroup;
import nl.rutgerkok.betterenderchest.chestowner.ChestOwner;
import nl.rutgerkok.betterenderchest.importers.InventoryImporter;
import nl.rutgerkok.betterenderchest.registry.Registration;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class WorldInventoriesImporter
extends InventoryImporter {
    @Override
    public String getName() {
        return "worldinventories";
    }

    @Override
    public Registration.Priority getPriority() {
        return Registration.Priority.NORMAL;
    }

    @Override
    public Inventory importInventory(ChestOwner chestOwner, WorldGroup worldGroup, BetterEnderChest plugin) throws IOException {
        String groupName = worldGroup.getGroupName();
        if (chestOwner.isSpecialChest()) {
            return null;
        }
        WorldInventories worldInventories = (WorldInventories)Bukkit.getServer().getPluginManager().getPlugin("WorldInventories");
        Group worldInventoriesGroup = null;
        ArrayList worldInventoriesGroups = WorldInventories.groups;
        for (Group group : worldInventoriesGroups) {
            if (!group.getName().equalsIgnoreCase(groupName)) continue;
            groupName = group.getName();
            worldInventoriesGroup = group;
            break;
        }
        if (worldInventoriesGroup == null) {
            plugin.warning("No matching WorldInventories group found for " + groupName + ". Cannot import " + chestOwner.getDisplayName() + ".");
            return null;
        }
        List<ItemStack> stacks = this.loadPlayerInventory(worldInventories, chestOwner, worldInventoriesGroup);
        if (stacks == null || stacks.size() == 0) {
            return null;
        }
        int rows = plugin.getEmptyInventoryProvider().getInventoryRows(chestOwner, stacks.listIterator());
        Inventory betterInventory = plugin.getEmptyInventoryProvider().loadEmptyInventory(chestOwner, worldGroup, rows);
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack stack = stacks.get(i);
            if (stack == null) continue;
            betterInventory.setItem(i, stack);
        }
        return betterInventory;
    }

    @Override
    public Iterable<WorldGroup> importWorldGroups(BetterEnderChest plugin) {
        HashSet<WorldGroup> becGroups = new HashSet<WorldGroup>();
        for (Group wiGroup : WorldInventories.groups) {
            WorldGroup becGroup = new WorldGroup(wiGroup.getName());
            becGroup.setInventoryImporter(this);
            becGroup.addWorlds(wiGroup.getWorlds());
            becGroups.add(becGroup);
        }
        return becGroups;
    }

    @Override
    public boolean isAvailable() {
        return Bukkit.getServer().getPluginManager().getPlugin("WorldInventories") != null;
    }

    private List<ItemStack> loadPlayerInventory(WorldInventories plugin, ChestOwner chestOwner, Group group) {
        File inventoriesFolder = new File(plugin.getDataFolder(), group.getName());
        File inventoryFile = new File(inventoriesFolder, chestOwner.getDisplayName() + ".enderchest." + WorldInventories.inventoryFileVersion + ".yml");
        if (inventoryFile.exists()) {
            YamlConfiguration pc = YamlConfiguration.loadConfiguration((File)inventoryFile);
            List stacks = pc.getList("enderchest", null);
            if (stacks == null) {
                return null;
            }
            return stacks;
        }
        return null;
    }
}

