/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest.chestprotection;

import java.util.Optional;
import java.util.UUID;
import nl.rutgerkok.betterenderchest.BetterEnderChest;
import nl.rutgerkok.betterenderchest.chestowner.ChestOwner;
import nl.rutgerkok.betterenderchest.chestprotection.ProtectionBridge;
import nl.rutgerkok.betterenderchest.registry.Registration;
import nl.rutgerkok.blocklocker.BlockLockerAPIv2;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class BlockLockerBridge
extends ProtectionBridge {
    private final BetterEnderChest plugin;

    public BlockLockerBridge(BetterEnderChest plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean canAccess(Player player, Block block) {
        return BlockLockerAPIv2.isAllowed((Player)player, (Block)block, (boolean)false);
    }

    @Override
    public ChestOwner getChestOwner(Block block) throws IllegalArgumentException {
        Optional owner = BlockLockerAPIv2.getOwner((Block)block);
        if (owner.isPresent()) {
            String name = ((OfflinePlayer)owner.get()).getName();
            UUID uuid = ((OfflinePlayer)owner.get()).getUniqueId();
            if (name == null) {
                name = "?";
            }
            return this.plugin.getChestOwners().playerChest(name, uuid);
        }
        return null;
    }

    @Override
    public String getName() {
        return "BlockLocker";
    }

    @Override
    public Registration.Priority getPriority() {
        return Registration.Priority.NORMAL;
    }

    @Override
    public boolean isAvailable() {
        return Bukkit.getPluginManager().getPlugin("BlockLocker") != null;
    }

    @Override
    public boolean isProtected(Block block) {
        return BlockLockerAPIv2.isProtected((Block)block);
    }
}

