/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest.chestowner;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import nl.rutgerkok.betterenderchest.BetterEnderChest;
import nl.rutgerkok.betterenderchest.chestowner.ChestOwner;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

final class UUIDFetcher
implements Callable<Map<String, ChestOwner>> {
    private static final String PROFILE_URL = "https://api.mojang.com/profiles/minecraft";
    private static final double PROFILES_PER_REQUEST = 100.0;
    private final JSONParser jsonParser = new JSONParser();
    private final List<String> names;
    private final BetterEnderChest plugin;
    private final boolean rateLimiting;
    private final Map<String, ChestOwner> specialChests;

    private static HttpURLConnection createConnection() throws IOException {
        URL url = new URL(PROFILE_URL);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        return connection;
    }

    private static UUID getUUID(String id) {
        return UUID.fromString(id.substring(0, 8) + "-" + id.substring(8, 12) + "-" + id.substring(12, 16) + "-" + id.substring(16, 20) + "-" + id.substring(20, 32));
    }

    private static void writeBody(HttpURLConnection connection, String body) throws IOException {
        OutputStream stream = connection.getOutputStream();
        stream.write(body.getBytes());
        stream.flush();
        stream.close();
    }

    public UUIDFetcher(BetterEnderChest plugin, Collection<String> names) {
        this(plugin, names, true);
    }

    public UUIDFetcher(BetterEnderChest plugin, Collection<String> names, boolean rateLimiting) {
        this.plugin = plugin;
        this.names = new ArrayList<String>(names);
        this.rateLimiting = rateLimiting;
        this.specialChests = new HashMap<String, ChestOwner>();
        if (names.remove("--publicchest")) {
            this.specialChests.put("--publicchest", plugin.getChestOwners().publicChest());
        }
        if (names.remove("--defaultchest")) {
            this.specialChests.put("--defaultchest", plugin.getChestOwners().defaultChest());
        }
    }

    @Override
    public Map<String, ChestOwner> call() throws IOException, ParseException {
        if (this.plugin.useUuidsForSaving()) {
            return this.callOnline();
        }
        return this.callOffline();
    }

    private Map<String, ChestOwner> callOffline() {
        HashMap<String, ChestOwner> results = new HashMap<String, ChestOwner>();
        for (String name : this.names) {
            results.put(name, this.plugin.getChestOwners().playerChest(name, null));
        }
        results.putAll(this.specialChests);
        return results;
    }

    private Map<String, ChestOwner> callOnline() throws IOException, ParseException {
        if (!this.plugin.useUuidsForSaving()) {
            throw new IllegalStateException();
        }
        HashMap<String, ChestOwner> uuidMap = new HashMap<String, ChestOwner>();
        int requests = (int)Math.ceil((double)this.names.size() / 100.0);
        for (int i = 0; i < requests; ++i) {
            HttpURLConnection connection = UUIDFetcher.createConnection();
            String body = JSONArray.toJSONString(this.names.subList(i * 100, Math.min((i + 1) * 100, this.names.size())));
            UUIDFetcher.writeBody(connection, body);
            JSONArray array = (JSONArray)this.jsonParser.parse((Reader)new InputStreamReader(connection.getInputStream()));
            for (Object profile : array) {
                JSONObject jsonProfile = (JSONObject)profile;
                String id = (String)jsonProfile.get((Object)"id");
                String name = (String)jsonProfile.get((Object)"name");
                UUID uuid = UUIDFetcher.getUUID(id);
                uuidMap.put(name, this.plugin.getChestOwners().playerChest(name, uuid));
            }
            if (!this.rateLimiting || i == requests - 1) continue;
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        uuidMap.putAll(this.specialChests);
        return uuidMap;
    }
}

