/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import nl.rutgerkok.betterenderchest.BetterEnderChest;
import nl.rutgerkok.betterenderchest.BetterEnderChestSizes;
import nl.rutgerkok.betterenderchest.BetterEnderInventoryHolder;
import nl.rutgerkok.betterenderchest.BetterEnderWorldGroupManager;
import nl.rutgerkok.betterenderchest.ChestDrop;
import nl.rutgerkok.betterenderchest.ChestOpener;
import nl.rutgerkok.betterenderchest.EmptyInventoryProvider;
import nl.rutgerkok.betterenderchest.Translation;
import nl.rutgerkok.betterenderchest.Translations;
import nl.rutgerkok.betterenderchest.chestowner.ChestOwners;
import nl.rutgerkok.betterenderchest.chestprotection.BlockLockerBridge;
import nl.rutgerkok.betterenderchest.chestprotection.LWCBridge;
import nl.rutgerkok.betterenderchest.chestprotection.LocketteBridge;
import nl.rutgerkok.betterenderchest.chestprotection.NoBridge;
import nl.rutgerkok.betterenderchest.chestprotection.ProtectionBridge;
import nl.rutgerkok.betterenderchest.command.BaseCommand;
import nl.rutgerkok.betterenderchest.command.BetterEnderCommandManager;
import nl.rutgerkok.betterenderchest.command.EnderChestCommand;
import nl.rutgerkok.betterenderchest.eventhandler.BetterEnderEventHandler;
import nl.rutgerkok.betterenderchest.eventhandler.BetterEnderSlotsHandler;
import nl.rutgerkok.betterenderchest.importers.BetterEnderFlatFileImporter;
import nl.rutgerkok.betterenderchest.importers.BetterEnderMySQLImporter;
import nl.rutgerkok.betterenderchest.importers.InventoryImporter;
import nl.rutgerkok.betterenderchest.importers.MultiInvImporter;
import nl.rutgerkok.betterenderchest.importers.MultiverseInventoriesImporter;
import nl.rutgerkok.betterenderchest.importers.MyWorldsImporter;
import nl.rutgerkok.betterenderchest.importers.NoneImporter;
import nl.rutgerkok.betterenderchest.importers.VanillaImporter;
import nl.rutgerkok.betterenderchest.importers.WorldInventoriesImporter;
import nl.rutgerkok.betterenderchest.io.BetterEnderCache;
import nl.rutgerkok.betterenderchest.io.DiscardingEnderCache;
import nl.rutgerkok.betterenderchest.io.SaveAndLoadError;
import nl.rutgerkok.betterenderchest.io.SimpleEnderCache;
import nl.rutgerkok.betterenderchest.io.file.BetterEnderFileHandler;
import nl.rutgerkok.betterenderchest.io.mysql.BetterEnderSQLCache;
import nl.rutgerkok.betterenderchest.io.mysql.DatabaseSettings;
import nl.rutgerkok.betterenderchest.itemfilter.ItemFilterReader;
import nl.rutgerkok.betterenderchest.nms.NMSHandler;
import nl.rutgerkok.betterenderchest.nms.SimpleNMSHandler;
import nl.rutgerkok.betterenderchest.registry.Registry;
import nl.rutgerkok.betterenderchest.util.BukkitExecutors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.BlockState;
import org.bukkit.block.ShulkerBox;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class BetterEnderChestPlugin
extends JavaPlugin
implements BetterEnderChest {
    private BukkitExecutors bukkitExecutors;
    private ChestDrop chestDrop;
    private ChestDrop chestDropSilkTouch;
    private ChestDrop chestDropCreative;
    private Material chestMaterial = Material.ENDER_CHEST;
    private ChestOpener chestOpener;
    private ChestOwners chestOwners;
    private File chestSaveLocation;
    private BetterEnderChestSizes chestSizes;
    private BetterEnderCommandManager commandManager;
    private Registry<BaseCommand> commands = new Registry();
    private boolean compatibilityMode;
    private DatabaseSettings databaseSettings;
    private boolean debug;
    private EmptyInventoryProvider emptyInventoryProvider;
    private BetterEnderCache enderCache;
    private BetterEnderWorldGroupManager groups;
    private Registry<InventoryImporter> importers = new Registry();
    private Predicate<ItemStack> isIllegalItem = Predicates.alwaysTrue();
    private boolean lockChestsOnError = true;
    private boolean manualGroupManagement;
    private Registry<NMSHandler> nmsHandlers = new Registry();
    private Registry<ProtectionBridge> protectionBridges = new Registry();
    private int rankUpgrades;
    private SaveAndLoadError saveAndLoadError;
    private boolean useUuids;

    @Override
    public synchronized boolean canSaveAndLoad() {
        return this.saveAndLoadError == null;
    }

    private boolean containsIllegalItemInShulker(ItemStack stack) {
        if (!Tag.SHULKER_BOXES.isTagged((Keyed)stack.getType())) {
            return false;
        }
        ItemMeta meta = stack.getItemMeta();
        if (!(meta instanceof BlockStateMeta)) {
            return false;
        }
        BlockState blockState = ((BlockStateMeta)meta).getBlockState();
        if (!(blockState instanceof ShulkerBox)) {
            return false;
        }
        for (ItemStack storedStack : ((ShulkerBox)blockState).getInventory().getContents()) {
            if (storedStack == null || !this.isIllegalItem.apply((Object)storedStack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void debug(String string) {
        if (this.debug) {
            this.log("[Debug] " + string);
        }
    }

    @Override
    public synchronized void disableSaveAndLoad(String reason, Throwable throwable) {
        if (this.saveAndLoadError == null) {
            if (this.lockChestsOnError) {
                this.severe(reason, throwable);
                this.severe("All Ender Chests are now locked to prevent potentially lost and duplicated items.");
                this.severe("If you really want to disable chest locking, see the config.yml:");
                this.severe("set the BetterEnderChest.lockChestsOnError setting to false.");
                this.saveAndLoadError = new SaveAndLoadError(reason, throwable);
            } else {
                this.severe("Although a critical error occured, the plugin will keep trying to save and load as requested in the config.yml.");
            }
        }
    }

    @Override
    public synchronized void enableSaveAndLoad() {
        this.saveAndLoadError = null;
    }

    @Override
    public BetterEnderCache getChestCache() {
        return this.enderCache;
    }

    @Override
    public ChestDrop getChestDropCreative() {
        return this.chestDropCreative;
    }

    @Override
    public ChestDrop getChestDropForPlayer(Player player) {
        if (player.getGameMode() == GameMode.CREATIVE) {
            return this.chestDropCreative;
        }
        ItemStack inHand = player.getInventory().getItemInMainHand();
        if (inHand.getEnchantments().containsKey(Enchantment.SILK_TOUCH)) {
            return this.chestDropSilkTouch;
        }
        return this.chestDrop;
    }

    @Override
    public ChestDrop getChestDropNormal() {
        return this.chestDrop;
    }

    @Override
    public ChestDrop getChestDropSilkTouch() {
        return this.chestDropSilkTouch;
    }

    @Override
    public Material getChestMaterial() {
        return this.chestMaterial;
    }

    @Override
    public ChestOpener getChestOpener() {
        return this.chestOpener;
    }

    @Override
    public ChestOwners getChestOwners() {
        return this.chestOwners;
    }

    @Override
    public File getChestSaveLocation() {
        return this.chestSaveLocation;
    }

    @Override
    public BetterEnderChestSizes getChestSizes() {
        return this.chestSizes;
    }

    @Override
    public BetterEnderCommandManager getCommandManager() {
        return this.commandManager;
    }

    @Override
    public Registry<BaseCommand> getCommands() {
        return this.commands;
    }

    @Override
    public boolean getCompatibilityMode() {
        return this.compatibilityMode;
    }

    @Override
    public DatabaseSettings getDatabaseSettings() {
        return this.databaseSettings;
    }

    @Override
    public EmptyInventoryProvider getEmptyInventoryProvider() {
        return this.emptyInventoryProvider;
    }

    @Override
    public BukkitExecutors getExecutors() {
        return this.bukkitExecutors;
    }

    @Override
    public Registry<InventoryImporter> getInventoryImporters() {
        return this.importers;
    }

    @Override
    public Registry<NMSHandler> getNMSHandlers() {
        return this.nmsHandlers;
    }

    public JavaPlugin getPlugin() {
        return this;
    }

    @Override
    public File getPluginFolder() {
        return this.getDataFolder();
    }

    @Override
    public Registry<ProtectionBridge> getProtectionBridges() {
        return this.protectionBridges;
    }

    @Override
    public BetterEnderWorldGroupManager getWorldGroupManager() {
        return this.groups;
    }

    @Override
    public boolean hasManualGroupManagement() {
        return this.manualGroupManagement;
    }

    public void initConfig() {
        int publicChestSlots;
        String publicCloseMessage;
        this.reloadConfig();
        FileConfiguration config = this.getConfig();
        config.set("BetterEnderChest.lastModifiedByVersion", (Object)this.getDescription().getVersion());
        String language = config.getString("BetterEnderChest.language", "en");
        File translationsFile = new File(this.getDataFolder(), "translations-" + language + ".yml");
        YamlConfiguration translationSettings = null;
        if (translationsFile.exists()) {
            translationSettings = YamlConfiguration.loadConfiguration((File)translationsFile);
            Translations.load(translationSettings);
        } else {
            translationSettings = new YamlConfiguration();
        }
        config.set("BetterEnderChest.language", (Object)language);
        this.useUuids = config.getBoolean("BetterEnderChest.useUUIDs", true);
        config.set("BetterEnderChest.useUUIDs", (Object)this.useUuids);
        String chestDrop = config.getString("BetterEnderChest.drop", "OBSIDIAN");
        chestDrop = chestDrop.toUpperCase();
        if (!this.isValidChestDrop(chestDrop)) {
            this.warning("Could not understand the drop " + chestDrop + ", defaulting to OBSIDIAN");
            chestDrop = ChestDrop.OBSIDIAN.toString();
        }
        config.set("BetterEnderChest.drop", (Object)chestDrop);
        this.chestDrop = ChestDrop.valueOf(chestDrop);
        String chestDropSilkTouch = config.getString("BetterEnderChest.dropSilkTouch", "ITSELF");
        chestDropSilkTouch = chestDropSilkTouch.toUpperCase();
        if (!this.isValidChestDrop(chestDropSilkTouch)) {
            this.warning("Could not understand the Silk Touch drop " + chestDropSilkTouch + ", defaulting to ITSELF");
            chestDropSilkTouch = ChestDrop.ITSELF.toString();
        }
        config.set("BetterEnderChest.dropSilkTouch", (Object)chestDropSilkTouch);
        this.chestDropSilkTouch = ChestDrop.valueOf(chestDropSilkTouch);
        String chestDropCreative = config.getString("BetterEnderChest.dropCreative", "NOTHING");
        chestDropCreative = chestDropCreative.toUpperCase();
        if (!this.isValidChestDrop(chestDropCreative)) {
            this.warning("Could not understand the drop for Creative Mode " + chestDropCreative + ", defaulting to NOTHING");
            chestDropCreative = ChestDrop.NOTHING.toString();
        }
        config.set("BetterEnderChest.dropCreative", (Object)chestDropCreative);
        this.chestDropCreative = ChestDrop.valueOf(chestDropCreative);
        this.compatibilityMode = config.getBoolean("BetterEnderChest.enderChestCompatibilityMode", config.getBoolean("BetterEnderChest.enderChestCompabilityMode", true));
        config.set("BetterEnderChest.enderChestCompatibilityMode", (Object)this.compatibilityMode);
        config.set("BetterEnderChest.enderChestCompabilityMode", null);
        this.debug = config.getBoolean("BetterEnderChest.showDebugMessages", false);
        config.set("BetterEnderChest.showDebugMessages", (Object)this.debug);
        this.lockChestsOnError = config.getBoolean("BetterEnderChest.lockChestsOnError", true);
        config.set("BetterEnderChest.lockChestsOnError", (Object)this.lockChestsOnError);
        boolean defaultManualGroupManagement = config.isConfigurationSection("Groups");
        this.manualGroupManagement = config.getBoolean("BetterEnderChest.manualWorldgroupManagement", defaultManualGroupManagement);
        config.set("BetterEnderChest.manualWorldgroupManagement", (Object)this.manualGroupManagement);
        int autoSaveIntervalSeconds = config.getInt("AutoSave.autoSaveIntervalSeconds", 5);
        if (autoSaveIntervalSeconds < 1) {
            this.warning("You need at least one second between each autosave. Changed it to one minute.");
            autoSaveIntervalSeconds = 60;
        }
        if (autoSaveIntervalSeconds >= 900) {
            this.warning("You have set a long time between the autosaves. Remember that chest unloading is also done during the autosave.");
        }
        config.set("AutoSave.autoSaveIntervalSeconds", (Object)autoSaveIntervalSeconds);
        AutoSave.autoSaveIntervalTicks = autoSaveIntervalSeconds * 20;
        config.set("AutoSave.showAutoSaveMessage", null);
        config.set("AutoSave.chestsPerSaveTick", null);
        config.set("AutoSave.saveTickIntervalTicks", null);
        List illegalItemsFoundInConfig = config.getMapList("IllegalItems");
        ArrayList illegalItems = Lists.newArrayList();
        ItemFilterReader itemFilterReader = new ItemFilterReader(this);
        for (Map entry : illegalItemsFoundInConfig) {
            illegalItems.add(itemFilterReader.apply(entry));
        }
        config.set("IllegalItems", (Object)illegalItemsFoundInConfig);
        this.isIllegalItem = Predicates.or((Iterable)illegalItems);
        this.rankUpgrades = config.getInt("PrivateEnderChest.rankUpgrades", 2);
        if (this.rankUpgrades < 0 || this.rankUpgrades > 20) {
            this.warning("The number of rank upgrades for the private chest was " + this.rankUpgrades + ". Changed it to 2.");
            this.rankUpgrades = 2;
        }
        config.set("PrivateEnderChest.rankUpgrades", (Object)this.rankUpgrades);
        int[] playerChestSlots = new int[this.rankUpgrades + 1];
        for (int i = 0; i < playerChestSlots.length; ++i) {
            Object slotSettingName = i > 0 ? "PrivateEnderChest.slotsUpgrade" + i : "PrivateEnderChest.defaultSlots";
            playerChestSlots[i] = config.getInt((String)slotSettingName, 27);
            if (playerChestSlots[i] < 1 || playerChestSlots[i] > 54) {
                this.warning("The number of slots (upgrade nr. " + i + ") in the private chest was " + playerChestSlots[i] + "...");
                this.warning("Changed it to 27.");
                playerChestSlots[i] = 27;
            }
            config.set((String)slotSettingName, (Object)playerChestSlots[i]);
        }
        PublicChest.openOnOpeningUnprotectedChest = config.getBoolean("PublicEnderChest.showOnOpeningUnprotectedChest", false);
        config.set("PublicEnderChest.showOnOpeningUnprotectedChest", (Object)PublicChest.openOnOpeningUnprotectedChest);
        PublicChest.openOnUsingCommand = config.getBoolean("PublicEnderChest.showOnUsingCommand", PublicChest.openOnOpeningUnprotectedChest);
        config.set("PublicEnderChest.showOnUsingCommand", (Object)PublicChest.openOnUsingCommand);
        String publicDisplayName = config.getString("PublicEnderChest.name", null);
        if (publicDisplayName != null) {
            Translations.PUBLIC_CHEST_TITLE = new Translation("Ender Chest (" + publicDisplayName + ")");
            config.set("PublicEnderChest.name", null);
        }
        if ((publicCloseMessage = config.getString("PublicEnderChest.closeMessage", null)) != null) {
            Translations.PUBLIC_CHEST_CLOSE_MESSAGE = new Translation(publicCloseMessage);
            config.set("PublicEnderChest.closeMessage", null);
        }
        if ((publicChestSlots = config.getInt("PublicEnderChest.defaultSlots", playerChestSlots[0])) < 1 || publicChestSlots > 54) {
            this.warning("The number of slots in the public chest was " + publicChestSlots + "...");
            this.warning("Changed it to 27.");
            publicChestSlots = 27;
        }
        config.set("PublicEnderChest.defaultSlots", (Object)publicChestSlots);
        this.getChestSizes().setSizes(publicChestSlots, playerChestSlots);
        this.databaseSettings = new DatabaseSettings(config);
        Translations.save(translationSettings);
        try {
            translationSettings.save(translationsFile);
        }
        catch (IOException e) {
            this.severe("Cannot save translations!", e);
        }
        this.groups.initConfig();
        this.saveConfig();
    }

    @Override
    public boolean isItemAllowedInChests(ItemStack stack) {
        Objects.requireNonNull(stack, "stack");
        if (this.isIllegalItem.apply((Object)stack)) {
            return false;
        }
        return !this.containsIllegalItemInShulker(stack);
    }

    public boolean isValidChestDrop(String drop) {
        try {
            ChestDrop.valueOf(drop);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public void log(String message) {
        this.getLogger().info(message);
    }

    public void onDisable() {
        if (this.enderCache != null) {
            this.log("Disabling... Saving all chests...");
            this.unloadIOServices();
            this.groups = null;
        }
    }

    public void onEnable() {
        this.nmsHandlers.register(new SimpleNMSHandler(this));
        this.nmsHandlers.selectAvailableRegistration();
        this.bukkitExecutors = new BukkitExecutors((Plugin)this);
        this.chestSaveLocation = new File(this.getDataFolder(), "chestData");
        this.protectionBridges.register(new LocketteBridge());
        this.protectionBridges.register(new LWCBridge(this));
        this.protectionBridges.register(new BlockLockerBridge(this));
        this.protectionBridges.register(new NoBridge());
        this.protectionBridges.selectAvailableRegistration();
        this.importers.register(new MultiInvImporter());
        this.importers.register(new MultiverseInventoriesImporter());
        this.importers.register(new WorldInventoriesImporter());
        this.importers.register(new MyWorldsImporter());
        this.importers.register(new BetterEnderFlatFileImporter(this));
        this.importers.register(new BetterEnderMySQLImporter());
        this.importers.register(new NoneImporter());
        this.importers.register(new VanillaImporter());
        this.importers.selectAvailableRegistration();
        if (this.chestSizes == null) {
            this.chestSizes = new BetterEnderChestSizes();
        }
        if (this.emptyInventoryProvider == null) {
            this.emptyInventoryProvider = new EmptyInventoryProvider(this);
        }
        this.chestOwners = new ChestOwners(this);
        if (this.chestOpener == null) {
            this.chestOpener = new ChestOpener(this);
        }
        this.groups = new BetterEnderWorldGroupManager(this);
        this.initConfig();
        this.enderCache = this.setupEnderCache();
        this.getServer().getPluginManager().registerEvents((Listener)new BetterEnderEventHandler(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BetterEnderSlotsHandler(this), (Plugin)this);
        this.commandManager = new BetterEnderCommandManager(this);
        this.getCommand("betterenderchest").setExecutor((CommandExecutor)this.commandManager);
        PluginCommand enderChestCommand = this.getCommand("enderchest");
        if (enderChestCommand != null) {
            enderChestCommand.setExecutor((CommandExecutor)new EnderChestCommand(this));
        }
        this.debug("Debug mode enabled. Thanks for helping to debug an issue! BetterEnderChest depends on people like you.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printSaveAndLoadError() {
        SaveAndLoadError error;
        BetterEnderChestPlugin betterEnderChestPlugin = this;
        synchronized (betterEnderChestPlugin) {
            error = this.saveAndLoadError;
        }
        if (error == null) {
            return;
        }
        this.severe("- ---------------------------------------------------------- -");
        this.severe("Saving and loading had to be disabled. Here's the error again:");
        this.severe("(Use \"/bec reload\" to try again to save and load.)");
        this.severe(error.getMessage(), error.getCause());
        this.severe("- ---------------------------------------------------------- -");
    }

    @Override
    public void reload() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!(player.getOpenInventory().getTopInventory().getHolder() instanceof BetterEnderInventoryHolder)) continue;
            player.closeInventory();
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "An admin reloaded all Ender Chests!");
        }
        this.unloadIOServices();
        this.enableSaveAndLoad();
        this.initConfig();
        this.enderCache = this.setupEnderCache();
    }

    private BetterEnderCache setupEnderCache() {
        NMSHandler nmsHandler = this.getNMSHandlers().getSelectedRegistration();
        if (nmsHandler == null) {
            Throwable emptyThrowable = new Throwable();
            emptyThrowable.setStackTrace(new StackTraceElement[0]);
            this.disableSaveAndLoad("Failed to access the net.minecraft.server classes. The usual cause of this is that the plugin is outdated, so please look for an update. Another possibility is that your Spigot build is outdated.", emptyThrowable);
            return new DiscardingEnderCache(this);
        }
        if (this.databaseSettings.isEnabled()) {
            return BetterEnderSQLCache.create(this);
        }
        BetterEnderFileHandler fileHandler = new BetterEnderFileHandler(nmsHandler, this.chestSaveLocation);
        return new SimpleEnderCache(this, fileHandler, fileHandler);
    }

    @Override
    public void severe(String message) {
        this.getLogger().severe(message);
    }

    @Override
    public void severe(String message, Throwable exception) {
        this.getLogger().log(Level.SEVERE, message, exception);
    }

    private void unloadIOServices() {
        this.enderCache.disable();
        this.enderCache = null;
    }

    @Override
    public boolean useUuidsForSaving() {
        return this.useUuids;
    }

    @Override
    public void warning(String message) {
        this.getLogger().warning(message);
    }

    public static class AutoSave {
        public static int autoSaveIntervalTicks = 100;
    }

    public static class PublicChest {
        public static boolean openOnOpeningUnprotectedChest;
        public static boolean openOnUsingCommand;
    }
}

