/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.interaction.commands.tags;

import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.formatter.language.Message;
import me.rockyhawk.commandpanels.interaction.commands.CommandTagResolver;
import me.rockyhawk.commandpanels.session.Panel;
import net.kyori.adventure.audience.Audience;
import org.bukkit.NamespacedKey;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Player;

public class SoundTag
implements CommandTagResolver {
    @Override
    public boolean isCorrectTag(String tag) {
        return tag.equalsIgnoreCase("[sound]");
    }

    @Override
    public void handle(Context ctx, Panel panel, Player player, String raw, String command) {
        String[] args = ctx.text.parseTextToString(player, command).split("\\s+");
        if (args.length == 0) {
            ctx.text.sendError((Audience)player, Message.SOUND_NO_ARGS, new Object[0]);
            return;
        }
        try {
            NamespacedKey key = this.parseKey(args[0].toLowerCase());
            float volume = 1.0f;
            float pitch = 1.0f;
            SoundCategory category = SoundCategory.MASTER;
            for (String arg : args) {
                if (arg.startsWith("volume=")) {
                    volume = Float.parseFloat(arg.substring(7));
                    continue;
                }
                if (arg.startsWith("pitch=")) {
                    pitch = Float.parseFloat(arg.substring(6));
                    continue;
                }
                if (!arg.startsWith("category=")) continue;
                try {
                    category = SoundCategory.valueOf((String)arg.substring(9).toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            player.playSound(player.getLocation(), key.toString(), category, volume, pitch);
        }
        catch (Exception e) {
            ctx.text.sendError((Audience)player, Message.SOUND_PLAY_FAIL, new Object[0]);
        }
    }

    private NamespacedKey parseKey(String key) {
        return key.contains(":") ? NamespacedKey.fromString((String)key) : NamespacedKey.minecraft((String)key);
    }
}

