/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.interaction.commands.tags;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.formatter.language.Message;
import me.rockyhawk.commandpanels.interaction.commands.CommandTagResolver;
import me.rockyhawk.commandpanels.session.Panel;
import me.rockyhawk.commandpanels.session.inventory.InventoryPanel;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemActionTag
implements CommandTagResolver {
    @Override
    public boolean isCorrectTag(String tag) {
        return tag.startsWith("[itemaction]");
    }

    @Override
    public void handle(Context ctx, Panel panel, Player player, String raw, String command) {
        try {
            String[] args = ctx.text.parseTextToString(player, command).split("\\s+");
            if (args.length < 2) {
                ctx.text.sendError((Audience)player, Message.ITEM_ACTION_SYNTAX_INVALID, new Object[0]);
                return;
            }
            int slot = Integer.parseInt(args[1]);
            String action = args[0].toLowerCase();
            Inventory gui = player.getOpenInventory().getTopInventory();
            ItemStack item = gui.getItem(slot);
            if (item == null || item.getType() == Material.AIR || !(panel instanceof InventoryPanel)) {
                return;
            }
            switch (action) {
                case "enchant": {
                    this.handleEnchant(item, args, ctx, player);
                    break;
                }
                case "repair": {
                    this.repairItem(item);
                    break;
                }
                case "amount": {
                    item.setAmount(Integer.parseInt(args[2]));
                    break;
                }
                case "remove": {
                    gui.setItem(slot, null);
                    break;
                }
                default: {
                    ctx.text.sendError((Audience)player, Message.ITEM_ACTION_UNKNOWN, new Object[0]);
                }
            }
            if (!action.equals("remove")) {
                gui.setItem(slot, item);
            }
        }
        catch (Exception e) {
            ctx.text.sendError((Audience)player, Message.ITEM_ACTION_EXECUTE_FAIL, new Object[0]);
        }
    }

    private void handleEnchant(ItemStack item, String[] args, Context ctx, Player player) {
        String sub;
        if (args.length < 3) {
            ctx.text.sendError((Audience)player, Message.ITEM_ACTION_USAGE_IMPROPER, new Object[0]);
            return;
        }
        switch (sub = args[2].toLowerCase()) {
            case "add": {
                if (args.length < 5) {
                    ctx.text.sendError((Audience)player, Message.ITEM_ENCHANT_MISSING_ARGS, new Object[0]);
                    return;
                }
                NamespacedKey key = args[3].contains(":") ? NamespacedKey.fromString((String)args[3].toLowerCase()) : NamespacedKey.minecraft((String)args[3].toLowerCase());
                Enchantment enchant = this.registryEnchant(key);
                int level = Integer.parseInt(args[4]);
                if (enchant != null) {
                    item.addUnsafeEnchantment(enchant, level);
                    break;
                }
                ctx.text.sendError((Audience)player, Message.ITEM_ENCHANT_INVALID, new Object[0]);
                break;
            }
            case "remove": {
                if (args.length < 4) {
                    ctx.text.sendError((Audience)player, Message.ITEM_ENCHANT_REMOVE_MISSING, new Object[0]);
                    return;
                }
                NamespacedKey key = args[3].contains(":") ? NamespacedKey.fromString((String)args[3].toLowerCase()) : NamespacedKey.minecraft((String)args[3].toLowerCase());
                Enchantment enchant = this.registryEnchant(key);
                if (enchant != null) {
                    item.removeEnchantment(enchant);
                    break;
                }
                ctx.text.sendError((Audience)player, Message.ITEM_ENCHANT_INVALID, new Object[0]);
                break;
            }
            case "clear": {
                item.getEnchantments().keySet().forEach(arg_0 -> ((ItemStack)item).removeEnchantment(arg_0));
                break;
            }
            default: {
                ctx.text.sendError((Audience)player, Message.ITEM_ENCHANT_ACTION_UNKNOWN, new Object[0]);
            }
        }
    }

    private void repairItem(ItemStack item) {
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta instanceof Damageable) {
            Damageable damageable = (Damageable)itemMeta;
            damageable.setDamage(0);
            item.setItemMeta((ItemMeta)damageable);
        }
    }

    private Enchantment registryEnchant(NamespacedKey key) {
        if (key != null) {
            return (Enchantment)RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).get(key);
        }
        return null;
    }
}

