/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.interaction.commands.requirements;

import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.CustomModelData;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.formatter.language.Message;
import me.rockyhawk.commandpanels.interaction.commands.RequirementTagResolver;
import me.rockyhawk.commandpanels.session.Panel;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ItemTag
implements RequirementTagResolver {
    @Override
    public boolean isCorrectTag(String tag) {
        return tag.equalsIgnoreCase("[item]");
    }

    @Override
    public boolean check(Context ctx, Panel panel, Player player, String raw, String args) {
        ParsedItemRequirement req = this.parseArgs(ctx, player, args);
        if (req == null) {
            return false;
        }
        return this.hasMatchingItems(ctx, player, req);
    }

    @Override
    public void execute(Context ctx, Panel panel, Player player, String raw, String args) {
        ParsedItemRequirement req = this.parseArgs(ctx, player, args);
        if (req == null) {
            return;
        }
        if (req.remove) {
            this.removeMatchingItems(ctx, player, req);
        }
    }

    private ParsedItemRequirement parseArgs(Context ctx, Player player, String args) {
        String raw;
        Material material;
        Map<String, String> map = this.parseArgumentMap(args);
        int amount = 1;
        boolean remove = true;
        String custom = null;
        NamespacedKey model = null;
        String source = "player";
        if (map.containsKey("material")) {
            try {
                material = Material.valueOf((String)map.get("material").toUpperCase());
            }
            catch (IllegalArgumentException e) {
                ctx.text.sendError((Audience)player, Message.REQUIREMENT_MATERIAL_INVALID, new Object[0]);
                return null;
            }
        } else {
            ctx.text.sendError((Audience)player, Message.REQUIREMENT_MATERIAL_REQUIRED, new Object[0]);
            return null;
        }
        if (map.containsKey("remove")) {
            remove = Boolean.parseBoolean(map.get("remove"));
        }
        if (map.containsKey("amount")) {
            try {
                amount = Integer.parseInt(map.get("amount"));
            }
            catch (NumberFormatException e) {
                ctx.text.sendError((Audience)player, Message.REQUIREMENT_AMOUNT_INVALID, new Object[0]);
                return null;
            }
        }
        if (map.containsKey("model") && (model = NamespacedKey.fromString((String)(raw = map.get("model")))) == null) {
            ctx.text.sendError((Audience)player, Message.ITEM_MODEL_INVALID, new Object[0]);
            return null;
        }
        if (map.containsKey("custom") && (custom = map.get("custom")).isEmpty()) {
            ctx.text.sendError((Audience)player, Message.ITEM_CUSTOM_MODEL_INVALID, new Object[0]);
            return null;
        }
        if (map.containsKey("source")) {
            String s = map.get("source").toLowerCase();
            if (!s.equals("player") && !s.equals("panel")) {
                ctx.text.sendError((Audience)player, Message.REQUIREMENT_SOURCE_INVALID, new Object[0]);
                return null;
            }
            source = s;
        }
        return new ParsedItemRequirement(material, amount, model, custom, source, remove);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasMatchingItems(Context ctx, Player player, ParsedItemRequirement req) {
        if (req.amount <= 0) {
            return true;
        }
        PlayerInventory inv = req.source.equals("panel") ? player.getOpenInventory().getTopInventory() : player.getInventory();
        NamespacedKey itemId = new NamespacedKey((Plugin)ctx.plugin, "item_id");
        int count = 0;
        int i = 0;
        while (true) {
            block15: {
                ItemStack item;
                block14: {
                    block16: {
                        ItemMeta meta;
                        if (i >= inv.getSize()) {
                            return false;
                        }
                        item = inv.getItem(i);
                        if (item == null || !item.getType().equals((Object)req.material) || (meta = item.getItemMeta()) == null || meta.getPersistentDataContainer().has(itemId, PersistentDataType.STRING) || (req.model == null ? meta.hasItemModel() : !meta.hasItemModel() || !req.model.equals((Object)meta.getItemModel()))) break block15;
                        if (req.custom == null) break block16;
                        if (item.getData(DataComponentTypes.CUSTOM_MODEL_DATA) != null) {
                            try {
                                float num = Float.parseFloat(req.custom);
                                if (!((CustomModelData)item.getData(DataComponentTypes.CUSTOM_MODEL_DATA)).floats().contains(Float.valueOf(num))) {
                                }
                                break block14;
                            }
                            catch (NumberFormatException e) {
                                if (((CustomModelData)item.getData(DataComponentTypes.CUSTOM_MODEL_DATA)).strings().contains(req.custom)) break block14;
                            }
                        }
                        break block15;
                    }
                    if (item.getData(DataComponentTypes.CUSTOM_MODEL_DATA) != null) break block15;
                }
                if ((count += item.getAmount()) >= req.amount) {
                    return true;
                }
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeMatchingItems(Context ctx, Player player, ParsedItemRequirement req) {
        PlayerInventory inv = req.source.equals("panel") ? player.getOpenInventory().getTopInventory() : player.getInventory();
        NamespacedKey itemId = new NamespacedKey((Plugin)ctx.plugin, "item_id");
        int toRemove = req.amount;
        int i = 0;
        while (i < inv.getSize()) {
            block14: {
                int stackAmount;
                ItemStack item;
                block13: {
                    block15: {
                        ItemMeta meta;
                        item = inv.getItem(i);
                        if (item == null || !item.getType().equals((Object)req.material) || (meta = item.getItemMeta()) == null || meta.getPersistentDataContainer().has(itemId, PersistentDataType.STRING) || (req.model == null ? meta.hasItemModel() : !meta.hasItemModel() || !req.model.equals((Object)meta.getItemModel()))) break block14;
                        if (req.custom == null) break block15;
                        if (item.getData(DataComponentTypes.CUSTOM_MODEL_DATA) != null) {
                            try {
                                float num = Float.parseFloat(req.custom);
                                if (!((CustomModelData)item.getData(DataComponentTypes.CUSTOM_MODEL_DATA)).floats().contains(Float.valueOf(num))) {
                                }
                                break block13;
                            }
                            catch (NumberFormatException e) {
                                if (((CustomModelData)item.getData(DataComponentTypes.CUSTOM_MODEL_DATA)).strings().contains(req.custom)) break block13;
                            }
                        }
                        break block14;
                    }
                    if (item.getData(DataComponentTypes.CUSTOM_MODEL_DATA) != null) break block14;
                }
                if ((stackAmount = item.getAmount()) > toRemove) {
                    item.setAmount(stackAmount - toRemove);
                    inv.setItem(i, item);
                    return;
                }
                inv.setItem(i, null);
                if ((toRemove -= stackAmount) <= 0) {
                    return;
                }
            }
            ++i;
        }
    }

    private Map<String, String> parseArgumentMap(String args) {
        HashMap<String, String> map = new HashMap<String, String>();
        Matcher matcher = Pattern.compile("(\\w+)=((\"[^\"]*\")|\\S+)").matcher(args);
        while (matcher.find()) {
            String key = matcher.group(1).toLowerCase();
            String value = matcher.group(2).replaceAll("^\"|\"$", "");
            map.put(key, value);
        }
        return map;
    }

    private static class ParsedItemRequirement {
        Material material;
        int amount;
        boolean remove;
        NamespacedKey model;
        String custom;
        String source;

        ParsedItemRequirement(Material material, int amount, NamespacedKey model, String custom, String source, boolean remove) {
            this.material = material;
            this.amount = amount;
            this.remove = remove;
            this.model = model;
            this.custom = custom;
            this.source = source;
        }
    }
}

