/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.builder.logic;

import java.util.List;
import me.rockyhawk.commandpanels.builder.logic.ComparisonNode;
import me.rockyhawk.commandpanels.builder.logic.ConditionNode;
import me.rockyhawk.commandpanels.builder.logic.LogicalNode;
import me.rockyhawk.commandpanels.builder.logic.NotNode;
import me.rockyhawk.commandpanels.builder.logic.Token;
import me.rockyhawk.commandpanels.builder.logic.Tokenizer;

public class ConditionParser {
    private List<Token> tokens;
    private int index;

    public ConditionNode parse(String input) {
        ConditionParser parser = new ConditionParser();
        parser.tokens = Tokenizer.tokenize(input);
        parser.index = 0;
        return parser.parseOr();
    }

    private ConditionNode parseOr() {
        ConditionNode left = this.parseAnd();
        while (this.match("$OR")) {
            ConditionNode right = this.parseAnd();
            left = new LogicalNode("$OR", List.of(left, right));
        }
        return left;
    }

    private ConditionNode parseAnd() {
        ConditionNode left = this.parsePrimary();
        while (this.match("$AND")) {
            ConditionNode right = this.parsePrimary();
            left = new LogicalNode("$AND", List.of(left, right));
        }
        return left;
    }

    private ConditionNode parsePrimary() {
        if (this.match("$NOT")) {
            ConditionNode node = this.parsePrimary();
            return new NotNode(node);
        }
        if (this.match("(")) {
            ConditionNode node = this.parseOr();
            this.expect(")");
            return node;
        }
        String left = this.nextToken().value;
        String operator = this.nextToken().value;
        String right = this.nextToken().value;
        return new ComparisonNode(left, operator, right);
    }

    private boolean match(String expected) {
        if (this.index < this.tokens.size() && this.tokens.get((int)this.index).value.equalsIgnoreCase(expected)) {
            ++this.index;
            return true;
        }
        return false;
    }

    private void expect(String expected) {
        if (!this.match(expected)) {
            throw new IllegalArgumentException("Expected token: " + expected);
        }
    }

    private Token nextToken() {
        if (this.index >= this.tokens.size()) {
            throw new IllegalStateException("Condition parsing failed. This usually means your condition syntax is incomplete or malformed. Check the panel configuration file.");
        }
        return this.tokens.get(this.index++);
    }
}

