/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.builder.inventory.items.utils;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import me.rockyhawk.commandpanels.Context;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.profile.PlayerTextures;

public class CustomHeads {
    private final Context ctx;
    private static final int MAX_CACHE_SIZE = 5000;
    private static final Map<String, PlayerProfile> profileCache = Collections.synchronizedMap(new LinkedHashMap<String, PlayerProfile>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, PlayerProfile> eldest) {
            return this.size() > 5000;
        }
    });
    private static final Queue<String> lookupQueue = new ConcurrentLinkedQueue<String>();
    private static boolean queueTaskRunning = false;

    public CustomHeads(Context ctx) {
        this.ctx = ctx;
    }

    public ItemStack getCustomHead(String base64Texture) {
        PlayerProfile profile = this.getOrCreateProfile(base64Texture);
        if (profile == null) {
            return new ItemStack(Material.PLAYER_HEAD);
        }
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD, 1);
        ItemMeta itemMeta = skull.getItemMeta();
        if (!(itemMeta instanceof SkullMeta)) {
            return skull;
        }
        SkullMeta skullMeta = (SkullMeta)itemMeta;
        skullMeta.setPlayerProfile(profile);
        skull.setItemMeta((ItemMeta)skullMeta);
        return skull;
    }

    private PlayerProfile getOrCreateProfile(String base64Texture) {
        return profileCache.computeIfAbsent(base64Texture, key -> {
            String skinUrl = this.extractSkinUrlFromBase64(base64Texture);
            if (skinUrl == null) {
                return null;
            }
            try {
                PlayerProfile profile = Bukkit.createProfile((UUID)UUID.randomUUID());
                PlayerTextures textures = profile.getTextures();
                textures.setSkin(new URL(skinUrl));
                profile.setTextures(textures);
                return profile;
            }
            catch (MalformedURLException e) {
                return null;
            }
        });
    }

    private String extractSkinUrlFromBase64(String base64Texture) {
        try {
            byte[] decodedBytes = Base64.getDecoder().decode(base64Texture);
            String decodedString = new String(decodedBytes, StandardCharsets.UTF_8);
            JsonObject jsonObject = JsonParser.parseString((String)decodedString).getAsJsonObject();
            JsonObject textures = jsonObject.getAsJsonObject("textures");
            JsonObject skin = textures.getAsJsonObject("SKIN");
            return skin.has("url") ? skin.get("url").getAsString() : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public ItemStack getPlayerHeadSync(String playerName) {
        Player onlinePlayer;
        String key = playerName.toLowerCase();
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD, 1);
        SkullMeta skullMeta = (SkullMeta)skull.getItemMeta();
        PlayerProfile profile = profileCache.get(key);
        if (profile == null && (onlinePlayer = Bukkit.getPlayerExact((String)playerName)) != null) {
            profile = onlinePlayer.getPlayerProfile();
            profileCache.put(key, profile);
        }
        if (!profileCache.containsKey(key)) {
            this.enqueuePlayerHead(key);
        }
        skullMeta.setPlayerProfile(profile);
        skull.setItemMeta((ItemMeta)skullMeta);
        return skull;
    }

    private void cachePlayerHeadAsync(String playerName) {
        String key = playerName.toLowerCase();
        Bukkit.getAsyncScheduler().runNow((Plugin)this.ctx.plugin, t -> {
            PlayerProfile p = Bukkit.createProfile((String)playerName);
            p.complete(true);
            if (p.isComplete()) {
                profileCache.put(key, p);
            } else {
                profileCache.put(key, null);
                this.enqueuePlayerHead(key);
            }
        });
    }

    private void enqueuePlayerHead(String key) {
        if (profileCache.containsKey(key) || lookupQueue.contains(key)) {
            return;
        }
        lookupQueue.add(key);
        this.startQueueProcessor();
    }

    private void startQueueProcessor() {
        if (queueTaskRunning) {
            return;
        }
        queueTaskRunning = true;
        Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)this.ctx.plugin, task -> {
            int maxPerTick = 3;
            for (int i = 0; i < maxPerTick; ++i) {
                String next = lookupQueue.poll();
                if (next == null) {
                    task.cancel();
                    queueTaskRunning = false;
                    return;
                }
                Bukkit.getAsyncScheduler().runNow((Plugin)this.ctx.plugin, t -> this.cachePlayerHeadAsync(next));
            }
        }, 1L, 20L);
    }
}

