/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.builder.dialog;

import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.registry.data.dialog.ActionButton;
import io.papermc.paper.registry.data.dialog.DialogBase;
import io.papermc.paper.registry.data.dialog.DialogRegistryEntry;
import io.papermc.paper.registry.data.dialog.body.DialogBody;
import io.papermc.paper.registry.data.dialog.input.DialogInput;
import io.papermc.paper.registry.data.dialog.type.DialogType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.builder.PanelBuilder;
import me.rockyhawk.commandpanels.builder.dialog.ActionBuilder;
import me.rockyhawk.commandpanels.builder.dialog.BodyBuilder;
import me.rockyhawk.commandpanels.builder.dialog.InputBuilder;
import me.rockyhawk.commandpanels.builder.logic.ConditionNode;
import me.rockyhawk.commandpanels.builder.logic.ConditionParser;
import me.rockyhawk.commandpanels.formatter.language.Message;
import me.rockyhawk.commandpanels.session.Panel;
import me.rockyhawk.commandpanels.session.dialog.DialogComponent;
import me.rockyhawk.commandpanels.session.dialog.DialogPanel;
import me.rockyhawk.commandpanels.session.dialog.components.DialogBodyText;
import me.rockyhawk.commandpanels.session.dialog.components.DialogButton;
import me.rockyhawk.commandpanels.session.dialog.components.DialogInputBool;
import me.rockyhawk.commandpanels.session.dialog.components.DialogInputOption;
import me.rockyhawk.commandpanels.session.dialog.components.DialogInputRange;
import me.rockyhawk.commandpanels.session.dialog.components.DialogInputText;
import me.rockyhawk.commandpanels.session.dialog.components.DialogItem;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.dialog.DialogLike;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;

public class DialogPanelBuilder
extends PanelBuilder {
    ActionBuilder buttonBuilder;
    InputBuilder inputBuilder;
    BodyBuilder bodyBuilder;
    private static final Pattern SIMPLE_INT_PATTERN = Pattern.compile("-?\\d+");
    private static final Pattern SIMPLE_FLOAT_PATTERN = Pattern.compile("-?\\d+(\\.\\d+)?");

    public DialogPanelBuilder(Context ctx, Player player) {
        super(ctx, player);
        this.buttonBuilder = new ActionBuilder(ctx, this);
        this.inputBuilder = new InputBuilder(ctx, this);
        this.bodyBuilder = new BodyBuilder(ctx, this);
    }

    @Override
    public void open(Panel openPanel) {
        if (!(openPanel instanceof DialogPanel)) {
            throw new IllegalArgumentException("Expected DialogPanel, got " + String.valueOf(openPanel.getClass()));
        }
        DialogPanel panel = (DialogPanel)openPanel;
        Player player = this.getPlayer();
        ArrayList<ActionButton> buttons = new ArrayList<ActionButton>();
        ArrayList<DialogInput> inputs = new ArrayList<DialogInput>();
        ArrayList<DialogBody> bodies = new ArrayList<DialogBody>();
        ArrayList<String> sortedOrder = new ArrayList<String>(panel.getOrder().keySet());
        sortedOrder.sort(Comparator.comparingInt(this::parseInt));
        block0: for (String key : sortedOrder) {
            for (String id : panel.getOrder().get(key)) {
                ConditionNode conditionNode;
                boolean result;
                DialogComponent comp;
                if (!panel.getComponents().containsKey(id) || !(comp = panel.getComponents().get(id)).getConditions().trim().isEmpty() && !(result = (conditionNode = new ConditionParser().parse(comp.getConditions())).evaluate(player, panel, this.ctx))) continue;
                DialogComponent dialogComponent = panel.getComponents().get(id);
                if (dialogComponent instanceof DialogButton) {
                    DialogButton button = (DialogButton)dialogComponent;
                    buttons.add(this.buttonBuilder.buildButton(button, panel));
                    continue block0;
                }
                dialogComponent = panel.getComponents().get(id);
                if (dialogComponent instanceof DialogItem) {
                    DialogItem item = (DialogItem)dialogComponent;
                    bodies.add(this.bodyBuilder.createItem(item, panel));
                    continue block0;
                }
                dialogComponent = panel.getComponents().get(id);
                if (dialogComponent instanceof DialogBodyText) {
                    DialogBodyText text = (DialogBodyText)dialogComponent;
                    bodies.add(this.bodyBuilder.createText(text, panel));
                    continue block0;
                }
                dialogComponent = panel.getComponents().get(id);
                if (dialogComponent instanceof DialogInputBool) {
                    DialogInputBool bool = (DialogInputBool)dialogComponent;
                    inputs.add(this.inputBuilder.createBool(bool));
                    continue block0;
                }
                dialogComponent = panel.getComponents().get(id);
                if (dialogComponent instanceof DialogInputRange) {
                    DialogInputRange range = (DialogInputRange)dialogComponent;
                    inputs.add(this.inputBuilder.createRange(range));
                    continue block0;
                }
                dialogComponent = panel.getComponents().get(id);
                if (dialogComponent instanceof DialogInputOption) {
                    DialogInputOption option = (DialogInputOption)dialogComponent;
                    inputs.add(this.inputBuilder.createOption(option));
                    continue block0;
                }
                dialogComponent = panel.getComponents().get(id);
                if (!(dialogComponent instanceof DialogInputText)) continue;
                DialogInputText inputText = (DialogInputText)dialogComponent;
                inputs.add(this.inputBuilder.createText(inputText));
                continue block0;
            }
        }
        boolean hasExitButton = Boolean.parseBoolean(this.ctx.text.parseTextToString(player, panel.getExitButton()));
        ActionButton exitAction = !buttons.isEmpty() && hasExitButton ? (ActionButton)buttons.removeLast() : null;
        if (buttons.isEmpty()) {
            this.ctx.text.sendError((Audience)player, Message.DIALOG_NO_BUTTONS, new Object[0]);
            return;
        }
        Dialog dialog = Dialog.create(dialogBuilder -> ((DialogRegistryEntry.Builder)dialogBuilder.empty()).base(DialogBase.builder((Component)this.ctx.text.parseTextToComponent(player, panel.getTitle())).canCloseWithEscape(Boolean.parseBoolean(this.ctx.text.parseTextToString(player, panel.getEscapable()))).body(bodies).inputs(inputs).build()).type((DialogType)DialogType.multiAction((List)buttons, (ActionButton)exitAction, (int)this.parseInt(panel.getColumns()))));
        player.showDialog((DialogLike)dialog);
    }

    public float parseFloat(String raw) {
        String parsed = this.ctx.text.parseTextToString(this.getPlayer(), raw);
        Matcher matcher = SIMPLE_FLOAT_PATTERN.matcher(parsed);
        if (matcher.find()) {
            try {
                return Float.parseFloat(matcher.group());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.0f;
    }

    public int parseInt(String raw) {
        String parsed = this.ctx.text.parseTextToString(this.getPlayer(), raw);
        Matcher matcher = SIMPLE_INT_PATTERN.matcher(parsed);
        if (matcher.find()) {
            try {
                return Integer.parseInt(matcher.group());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }
}

