/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.session.inventory.listeners;

import java.util.ArrayList;
import java.util.HashMap;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.interaction.commands.CommandRunner;
import me.rockyhawk.commandpanels.interaction.commands.RequirementRunner;
import me.rockyhawk.commandpanels.session.CommandActions;
import me.rockyhawk.commandpanels.session.inventory.InventoryPanel;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class InventoryEvents
implements Listener {
    private final Context ctx;

    public InventoryEvents(Context ctx) {
        this.ctx = ctx;
    }

    @EventHandler
    public void onCloseEvent(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Bukkit.getGlobalRegionScheduler().run((Plugin)this.ctx.plugin, task -> {
            InventoryHolder patt0$temp = event.getInventory().getHolder();
            if (patt0$temp instanceof InventoryPanel) {
                InventoryPanel currentPanel;
                InventoryPanel panel = (InventoryPanel)patt0$temp;
                InventoryHolder patt1$temp = player.getOpenInventory().getTopInventory().getHolder();
                if (patt1$temp instanceof InventoryPanel && (currentPanel = (InventoryPanel)patt1$temp) == panel) {
                    return;
                }
                this.itemSanitiser(player.getInventory());
                this.itemDropper(player, event.getInventory());
                RequirementRunner requirements = new RequirementRunner(this.ctx);
                CommandRunner commands = new CommandRunner(this.ctx);
                CommandActions actions = panel.getCloseCommands();
                if (!requirements.processRequirements(panel, player, actions.requirements())) {
                    commands.runCommands(panel, player, actions.fail());
                    return;
                }
                commands.runCommands(panel, player, actions.commands());
            }
        });
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.closePanels(event.getPlayer());
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        this.closePanels(event.getPlayer());
    }

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        this.closePanels(event.getPlayer());
    }

    private void closePanels(Player p) {
        if (p.getOpenInventory() != null && p.getOpenInventory().getTopInventory().getHolder() instanceof InventoryPanel) {
            p.closeInventory();
        }
    }

    private void itemSanitiser(PlayerInventory inv) {
        if (inv == null) {
            return;
        }
        ArrayList<ItemStack> toRemove = new ArrayList<ItemStack>();
        NamespacedKey key = new NamespacedKey((Plugin)this.ctx.plugin, "item_id");
        for (ItemStack item : inv.getContents()) {
            String itemName;
            ItemMeta meta;
            if (item == null || (meta = item.getItemMeta()) == null || (itemName = (String)meta.getPersistentDataContainer().get(key, PersistentDataType.STRING)) == null) continue;
            toRemove.add(item);
        }
        for (ItemStack item : toRemove) {
            inv.remove(item);
        }
    }

    private void itemDropper(Player player, Inventory inventory) {
        NamespacedKey key = new NamespacedKey((Plugin)this.ctx.plugin, "item_id");
        PlayerInventory playerInv = player.getInventory();
        for (int i = 0; i < inventory.getSize(); ++i) {
            boolean isPanelItem;
            ItemStack item = inventory.getItem(i);
            if (item == null || item.getType().isAir()) continue;
            ItemMeta meta = item.getItemMeta();
            boolean bl = isPanelItem = meta != null && meta.getPersistentDataContainer().has(key, PersistentDataType.STRING);
            if (isPanelItem) continue;
            HashMap leftovers = playerInv.addItem(new ItemStack[]{item});
            for (ItemStack leftover : leftovers.values()) {
                player.getWorld().dropItemNaturally(player.getLocation(), leftover);
            }
        }
        inventory.clear();
    }
}

