/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.session.inventory;

import io.papermc.paper.persistence.PersistentDataContainerView;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.HashMap;
import java.util.Map;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.builder.inventory.InventoryPanelBuilder;
import me.rockyhawk.commandpanels.builder.inventory.items.ItemBuilder;
import me.rockyhawk.commandpanels.session.inventory.InventoryPanel;
import me.rockyhawk.commandpanels.session.inventory.PanelItem;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class InventoryPanelUpdater {
    private ScheduledTask heartbeatTask;
    private ScheduledTask updateTask;
    private final Map<String, Boolean> lastObservedPermStates = new HashMap<String, Boolean>();

    public void start(Context ctx, Player p, InventoryPanel panel) {
        this.stop();
        this.startHeartbeat(ctx, p, panel);
        int updateDelay = this.parseUpdateDelay(panel.getUpdateDelay());
        if (updateDelay > 0) {
            this.startUpdater(ctx, p, panel, updateDelay);
        }
    }

    private void startHeartbeat(Context ctx, Player p, InventoryPanel panel) {
        boolean isUsingPermObserver = ctx.fileHandler.config.getBoolean("permission-observer");
        this.heartbeatTask = p.getScheduler().runAtFixedRate((Plugin)ctx.plugin, task -> {
            Inventory inv = p.getOpenInventory().getTopInventory();
            InventoryHolder holder = inv.getHolder();
            if (!(holder instanceof InventoryPanel) || holder != panel) {
                this.stop();
                return;
            }
            if (!isUsingPermObserver) {
                return;
            }
            for (String node : panel.getObservedPerms()) {
                boolean current;
                Boolean previous = this.lastObservedPermStates.put(node, current = p.hasPermission(node));
                if (previous == null || previous == current) continue;
                panel.open(ctx, p, false);
                return;
            }
        }, null, 2L, 2L);
    }

    private void startUpdater(Context ctx, Player p, InventoryPanel panel, int updateDelay) {
        InventoryPanelBuilder panelBuilder = new InventoryPanelBuilder(ctx, p);
        ItemBuilder builder = new ItemBuilder(ctx, panelBuilder);
        NamespacedKey itemIdKey = new NamespacedKey((Plugin)ctx.plugin, "item_id");
        NamespacedKey baseIdKey = new NamespacedKey((Plugin)ctx.plugin, "base_item_id");
        NamespacedKey fillItem = new NamespacedKey((Plugin)ctx.plugin, "fill_item");
        this.updateTask = p.getScheduler().runAtFixedRate((Plugin)ctx.plugin, task -> {
            Inventory inv = p.getOpenInventory().getTopInventory();
            InventoryHolder holder = inv.getHolder();
            if (!(holder instanceof InventoryPanel) || holder != panel) {
                this.stopUpdater();
                return;
            }
            for (int slot = 0; slot < inv.getSize(); ++slot) {
                PersistentDataContainerView container;
                ItemStack item = inv.getItem(slot);
                if (item == null || item.getType().isAir() || !(container = item.getPersistentDataContainer()).has(itemIdKey, PersistentDataType.STRING) || container.has(fillItem, PersistentDataType.STRING)) continue;
                String itemId = (String)container.get(itemIdKey, PersistentDataType.STRING);
                String baseItemId = (String)container.get(baseIdKey, PersistentDataType.STRING);
                PanelItem panelItem = panel.getItems().get(itemId);
                if (!panelItem.animate().isEmpty()) {
                    PanelItem animateItem = panel.getItems().get(panelItem.animate());
                    if (animateItem != null) {
                        panelItem = animateItem;
                    }
                } else if (!baseItemId.equals(itemId)) {
                    panelItem = panel.getItems().get(baseItemId);
                }
                ItemStack newItem = builder.buildItem(panel, panelItem);
                newItem.editPersistentDataContainer(c -> c.set(baseIdKey, PersistentDataType.STRING, (Object)baseItemId));
                inv.setItem(slot, newItem);
            }
        }, null, (long)updateDelay, (long)updateDelay);
    }

    private int parseUpdateDelay(String delayStr) {
        if (delayStr != null && delayStr.matches("\\d+")) {
            return Integer.parseInt(delayStr);
        }
        return 20;
    }

    public void stop() {
        this.stopHeartbeat();
        this.stopUpdater();
    }

    private void stopHeartbeat() {
        if (this.heartbeatTask != null) {
            this.heartbeatTask.cancel();
            this.heartbeatTask = null;
        }
    }

    private void stopUpdater() {
        if (this.updateTask != null) {
            this.updateTask.cancel();
            this.updateTask = null;
        }
    }
}

