/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.interaction.commands.tags;

import java.util.HashMap;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.formatter.language.Message;
import me.rockyhawk.commandpanels.interaction.commands.CommandTagResolver;
import me.rockyhawk.commandpanels.session.Panel;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class GiveTag
implements CommandTagResolver {
    @Override
    public boolean isCorrectTag(String tag) {
        return tag.startsWith("[give]");
    }

    @Override
    public void handle(Context ctx, Panel panel, Player player, String raw, String command) {
        String[] parts = command.split("\\s+");
        if (parts.length < 1) {
            return;
        }
        try {
            Material material = Material.matchMaterial((String)parts[0].toUpperCase());
            if (material == null || !material.isItem()) {
                ctx.text.sendError((Audience)player, Message.REQUIREMENT_ITEM_INVALID, new Object[0]);
                return;
            }
            int amount = 1;
            if (parts.length >= 2) {
                amount = Math.max(1, Integer.parseInt(parts[1]));
            }
            ItemStack item = new ItemStack(material, amount);
            HashMap leftover = player.getInventory().addItem(new ItemStack[]{item});
            for (ItemStack left : leftover.values()) {
                player.getWorld().dropItemNaturally(player.getLocation(), left);
            }
        }
        catch (Exception e) {
            ctx.text.sendError((Audience)player, Message.ITEM_GIVE_ERROR, new Object[0]);
        }
    }
}

