/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.builder.inventory.items;

import java.util.ArrayList;
import java.util.List;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.builder.PanelBuilder;
import me.rockyhawk.commandpanels.builder.inventory.items.ItemComponent;
import me.rockyhawk.commandpanels.builder.inventory.items.MaterialComponent;
import me.rockyhawk.commandpanels.builder.inventory.items.itemcomponents.BannerComponent;
import me.rockyhawk.commandpanels.builder.inventory.items.itemcomponents.CustomModelDataComponent;
import me.rockyhawk.commandpanels.builder.inventory.items.itemcomponents.DamageComponent;
import me.rockyhawk.commandpanels.builder.inventory.items.itemcomponents.EnchantedComponent;
import me.rockyhawk.commandpanels.builder.inventory.items.itemcomponents.ItemModelComponent;
import me.rockyhawk.commandpanels.builder.inventory.items.itemcomponents.LeatherColorComponent;
import me.rockyhawk.commandpanels.builder.inventory.items.itemcomponents.PotionColorComponent;
import me.rockyhawk.commandpanels.builder.inventory.items.itemcomponents.PotionComponent;
import me.rockyhawk.commandpanels.builder.inventory.items.itemcomponents.StackComponent;
import me.rockyhawk.commandpanels.builder.inventory.items.itemcomponents.TooltipComponent;
import me.rockyhawk.commandpanels.builder.inventory.items.itemcomponents.TrimComponent;
import me.rockyhawk.commandpanels.builder.inventory.items.materialcomponents.HeadComponent;
import me.rockyhawk.commandpanels.builder.inventory.items.materialcomponents.HeadDatabaseComponent;
import me.rockyhawk.commandpanels.builder.inventory.items.materialcomponents.ItemsAdderComponent;
import me.rockyhawk.commandpanels.builder.inventory.items.materialcomponents.MMOItemsComponent;
import me.rockyhawk.commandpanels.builder.inventory.items.materialcomponents.MinecraftComponent;
import me.rockyhawk.commandpanels.builder.inventory.items.materialcomponents.NexoComponent;
import me.rockyhawk.commandpanels.builder.inventory.items.utils.NameHandler;
import me.rockyhawk.commandpanels.formatter.language.Message;
import me.rockyhawk.commandpanels.session.Panel;
import me.rockyhawk.commandpanels.session.inventory.PanelItem;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class ItemBuilder {
    private final Context ctx;
    private final List<MaterialComponent> materialComponents = new ArrayList<MaterialComponent>();
    private final List<ItemComponent> itemComponents = new ArrayList<ItemComponent>();
    private final PanelBuilder panelBuilder;
    private final NameHandler name;

    public ItemBuilder(Context ctx, PanelBuilder panelBuilder) {
        this.ctx = ctx;
        this.name = new NameHandler(ctx);
        this.panelBuilder = panelBuilder;
        this.initialiseComponents();
    }

    @NotNull
    public ItemStack buildItem(Panel panel, PanelItem item) {
        Player p = this.panelBuilder.getPlayer();
        if (item == null) {
            return new ItemStack(Material.AIR);
        }
        ItemStack itemStack = this.builder(item, p.getPlayer());
        Material type = itemStack.getType();
        if (type == Material.AIR || type == Material.VOID_AIR || type == Material.CAVE_AIR) {
            return itemStack;
        }
        NamespacedKey itemId = new NamespacedKey((Plugin)this.ctx.plugin, "item_id");
        NamespacedKey baseItemId = new NamespacedKey((Plugin)this.ctx.plugin, "base_item_id");
        itemStack.editPersistentDataContainer(c -> c.set(itemId, PersistentDataType.STRING, (Object)item.id()));
        itemStack.editPersistentDataContainer(c -> c.set(baseItemId, PersistentDataType.STRING, (Object)item.id()));
        return itemStack;
    }

    @NotNull
    private ItemStack builder(PanelItem item, Player player) {
        String material = this.ctx.text.parseTextToString(player, item.material());
        ItemStack baseItem = null;
        String[] parts = material.split("\\s+", 2);
        String tag = parts[0];
        String args = parts.length > 1 ? parts[1].trim() : "";
        for (MaterialComponent mc : this.materialComponents) {
            if (!mc.isCorrectTag(tag)) continue;
            try {
                baseItem = mc.createItem(this.ctx, args, player, item);
                break;
            }
            catch (Exception e) {
                this.ctx.text.sendError((Audience)player, Message.ITEM_CREATE_FAIL, item.id(), mc.getClass().getSimpleName());
            }
        }
        if (baseItem == null && (baseItem = new MinecraftComponent().createItem(this.ctx, material, player, item)) == null) {
            return new ItemStack(Material.AIR);
        }
        for (ItemComponent ic : this.itemComponents) {
            try {
                baseItem = ic.apply(this.ctx, baseItem, player, item);
            }
            catch (Exception e) {
                this.ctx.text.sendError((Audience)player, Message.ITEM_DECORATION_FAIL, item.id(), ic.getClass().getSimpleName());
            }
        }
        baseItem = this.name.setName(baseItem, item, player);
        return baseItem;
    }

    private void initialiseComponents() {
        this.materialComponents.add(new MinecraftComponent());
        this.materialComponents.add(new HeadComponent());
        this.materialComponents.add(new NexoComponent());
        this.materialComponents.add(new ItemsAdderComponent());
        this.materialComponents.add(new MMOItemsComponent());
        this.materialComponents.add(new HeadDatabaseComponent());
        this.itemComponents.add(new EnchantedComponent());
        this.itemComponents.add(new ItemModelComponent());
        this.itemComponents.add(new CustomModelDataComponent());
        this.itemComponents.add(new TooltipComponent());
        this.itemComponents.add(new BannerComponent());
        this.itemComponents.add(new LeatherColorComponent());
        this.itemComponents.add(new PotionComponent());
        this.itemComponents.add(new PotionColorComponent());
        this.itemComponents.add(new DamageComponent());
        this.itemComponents.add(new TrimComponent());
        this.itemComponents.add(new StackComponent());
    }
}

