/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.builder.dialog;

import io.papermc.paper.registry.data.dialog.input.DialogInput;
import io.papermc.paper.registry.data.dialog.input.SingleOptionDialogInput;
import io.papermc.paper.registry.data.dialog.input.TextDialogInput;
import java.util.ArrayList;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.builder.dialog.DialogPanelBuilder;
import me.rockyhawk.commandpanels.session.dialog.components.DialogInputBool;
import me.rockyhawk.commandpanels.session.dialog.components.DialogInputOption;
import me.rockyhawk.commandpanels.session.dialog.components.DialogInputRange;
import me.rockyhawk.commandpanels.session.dialog.components.DialogInputText;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;

public class InputBuilder {
    private final Context ctx;
    private final DialogPanelBuilder builder;

    public InputBuilder(Context ctx, DialogPanelBuilder builder) {
        this.ctx = ctx;
        this.builder = builder;
    }

    public DialogInput createText(DialogInputText item) {
        boolean hasRows;
        Player player = this.builder.getPlayer();
        TextDialogInput.Builder inputBuilder = DialogInput.text((String)item.getId(), (Component)this.ctx.text.parseTextToComponent(player, item.getName())).initial(this.ctx.text.applyPlaceholders(player, item.getInitial())).width(this.builder.parseInt(item.getWidth())).maxLength(this.builder.parseInt(item.getMaxLength()));
        boolean hasHeight = item.getHeight() != null && !item.getHeight().isEmpty();
        boolean bl = hasRows = item.getMultilineRows() != null && !item.getMultilineRows().isEmpty();
        if (hasHeight && hasRows) {
            inputBuilder.multiline(TextDialogInput.MultilineOptions.create((Integer)this.builder.parseInt(item.getMultilineRows()), (Integer)this.builder.parseInt(item.getHeight())));
        }
        return inputBuilder.build();
    }

    public DialogInput createBool(DialogInputBool comp) {
        Player player = this.builder.getPlayer();
        return DialogInput.bool((String)comp.getId(), (Component)this.ctx.text.parseTextToComponent(player, comp.getName())).initial(Boolean.parseBoolean(this.ctx.text.parseTextToString(player, comp.getInitial()))).build();
    }

    public DialogInput createRange(DialogInputRange comp) {
        Player player = this.builder.getPlayer();
        return DialogInput.numberRange((String)comp.getId(), (Component)this.ctx.text.parseTextToComponent(player, comp.getName()), (float)this.builder.parseFloat(comp.getStart()), (float)this.builder.parseFloat(comp.getEnd())).initial(Float.valueOf(this.builder.parseFloat(comp.getInitial()))).step(Float.valueOf(this.builder.parseFloat(comp.getStep()))).width(this.builder.parseInt(comp.getWidth())).build();
    }

    public DialogInput createOption(DialogInputOption comp) {
        Player player = this.builder.getPlayer();
        ArrayList<SingleOptionDialogInput.OptionEntry> options = new ArrayList<SingleOptionDialogInput.OptionEntry>();
        for (String option : comp.getOptions()) {
            Component compOption = this.ctx.text.parseTextToComponent(player, option);
            String initial = this.ctx.text.parseTextToString(player, comp.getInitial());
            boolean isInitial = initial.equalsIgnoreCase(option);
            options.add(SingleOptionDialogInput.OptionEntry.create((String)option, (Component)compOption, (boolean)isInitial));
        }
        return DialogInput.singleOption((String)comp.getId(), (Component)this.ctx.text.parseTextToComponent(player, comp.getName()), options).width(this.builder.parseInt(comp.getWidth())).build();
    }
}

