/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.session.floodgate;

import me.rockyhawk.commandpanels.session.CommandActions;
import me.rockyhawk.commandpanels.session.floodgate.components.FloodgateButton;
import me.rockyhawk.commandpanels.session.floodgate.components.FloodgateDropdown;
import me.rockyhawk.commandpanels.session.floodgate.components.FloodgateInput;
import me.rockyhawk.commandpanels.session.floodgate.components.FloodgateLabel;
import me.rockyhawk.commandpanels.session.floodgate.components.FloodgateSlider;
import me.rockyhawk.commandpanels.session.floodgate.components.FloodgateStepSlider;
import me.rockyhawk.commandpanels.session.floodgate.components.FloodgateToggle;
import org.bukkit.configuration.ConfigurationSection;

public abstract class FloodgateComponent {
    private final String id;
    private final String name;
    private final String conditions;
    private final String type;
    private final CommandActions actions;

    public FloodgateComponent(String id, ConfigurationSection config) {
        this.id = id;
        this.conditions = config.getString("conditions", "");
        this.name = config.getString("name", "");
        this.type = config.getString("type", "button");
        this.actions = CommandActions.fromSection(config.getConfigurationSection("actions"));
    }

    public static FloodgateComponent fromSection(String id, ConfigurationSection section) {
        String type = section.getString("type", "button");
        return switch (type.toLowerCase()) {
            case "button" -> new FloodgateButton(id, section);
            case "label" -> new FloodgateLabel(id, section);
            case "dropdown" -> new FloodgateDropdown(id, section);
            case "input" -> new FloodgateInput(id, section);
            case "slider" -> new FloodgateSlider(id, section);
            case "step-slider" -> new FloodgateStepSlider(id, section);
            case "toggle" -> new FloodgateToggle(id, section);
            default -> null;
        };
    }

    public String getName() {
        return this.name;
    }

    public String getConditions() {
        return this.conditions;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public CommandActions getClickActions() {
        return this.actions;
    }
}

