/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.interaction.openpanel;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import me.rockyhawk.commandpanels.Context;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.plugin.Plugin;

public class CommandRegister {
    private final Context ctx;
    private final CommandMap commandMap;

    public CommandRegister(Context ctx) {
        this.ctx = ctx;
        this.commandMap = this.getCommandMap();
    }

    public void registerPanelCommand(String command) {
        if (this.commandMap == null) {
            return;
        }
        if (command.isEmpty()) {
            return;
        }
        if (Bukkit.getPluginCommand((String)command) != null) {
            return;
        }
        PluginCommand pluginCommand = this.createPluginCommand(command, (Plugin)this.ctx.plugin);
        if (pluginCommand != null) {
            this.commandMap.register(this.ctx.plugin.getDescription().getName(), (Command)pluginCommand);
        }
    }

    private CommandMap getCommandMap() {
        try {
            Field commandMapField = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            return (CommandMap)commandMapField.get(Bukkit.getServer());
        }
        catch (Exception e) {
            return null;
        }
    }

    private PluginCommand createPluginCommand(String name, Plugin plugin) {
        try {
            Constructor constructor = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
            constructor.setAccessible(true);
            return (PluginCommand)constructor.newInstance(name, plugin);
        }
        catch (Exception e) {
            return null;
        }
    }
}

