/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.interaction.commands.requirements;

import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.formatter.language.Message;
import me.rockyhawk.commandpanels.interaction.commands.RequirementTagResolver;
import me.rockyhawk.commandpanels.session.Panel;
import net.kyori.adventure.audience.Audience;
import org.bukkit.entity.Player;

public class XpTag
implements RequirementTagResolver {
    @Override
    public boolean isCorrectTag(String tag) {
        return tag.equalsIgnoreCase("[xp]");
    }

    @Override
    public boolean check(Context ctx, Panel panel, Player player, String raw, String args) {
        String type;
        int amount;
        String[] split = args.trim().split("\\s");
        if (split.length != 2) {
            ctx.text.sendError((Audience)player, Message.REQUIREMENT_XP_INVALID, new Object[0]);
            return false;
        }
        try {
            amount = Integer.parseInt(split[1]);
        }
        catch (NumberFormatException e) {
            ctx.text.sendError((Audience)player, Message.REQUIREMENT_XP_AMOUNT_INVALID, new Object[0]);
            return false;
        }
        return switch (type = split[0].toLowerCase()) {
            case "levels" -> {
                if (player.getLevel() >= amount) {
                    yield true;
                }
                yield false;
            }
            case "points" -> {
                if (this.getPlayerExp(player) >= amount) {
                    yield true;
                }
                yield false;
            }
            default -> {
                ctx.text.sendError((Audience)player, Message.REQUIREMENT_XP_TYPE_INVALID, new Object[0]);
                yield false;
            }
        };
    }

    @Override
    public void execute(Context ctx, Panel panel, Player player, String raw, String args) {
        String type;
        int amount;
        String[] split = args.trim().split("\\s");
        if (split.length != 2) {
            return;
        }
        try {
            amount = Integer.parseInt(split[1]);
        }
        catch (NumberFormatException e) {
            return;
        }
        switch (type = split[0].toLowerCase()) {
            case "levels": {
                player.setLevel(player.getLevel() - amount);
                break;
            }
            case "points": {
                this.removePlayerExp(player, amount);
            }
        }
    }

    private int getExpAtLevel(int level) {
        if (level <= 16) {
            return level * level + 6 * level;
        }
        if (level <= 31) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
    }

    private int getExpToLevelUp(int level) {
        if (level <= 15) {
            return 2 * level + 7;
        }
        if (level <= 30) {
            return 5 * level - 38;
        }
        return 9 * level - 158;
    }

    private int getPlayerExp(Player player) {
        int level = player.getLevel();
        float progress = player.getExp();
        return this.getExpAtLevel(level) + Math.round((float)this.getExpToLevelUp(level) * progress);
    }

    private void removePlayerExp(Player player, int exp) {
        int total = this.getPlayerExp(player);
        player.setExp(0.0f);
        player.setLevel(0);
        player.giveExp(Math.max(0, total - exp));
    }
}

