/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.interaction.commands.requirements;

import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.formatter.language.Message;
import me.rockyhawk.commandpanels.interaction.commands.RequirementTagResolver;
import me.rockyhawk.commandpanels.session.Panel;
import net.kyori.adventure.audience.Audience;
import org.bukkit.entity.Player;

public class DataTag
implements RequirementTagResolver {
    @Override
    public boolean isCorrectTag(String tag) {
        return tag.equalsIgnoreCase("[data]");
    }

    @Override
    public boolean check(Context ctx, Panel panel, Player player, String raw, String args) {
        double currentAmount;
        double requiredAmount;
        String[] split = args.trim().split("\\s");
        if (split.length != 2) {
            ctx.text.sendError((Audience)player, Message.REQUIREMENT_DATA_INVALID, new Object[0]);
            return false;
        }
        String dataKey = split[0];
        try {
            requiredAmount = Double.parseDouble(split[1]);
        }
        catch (NumberFormatException e) {
            ctx.text.sendError((Audience)player, Message.REQUIREMENT_AMOUNT_INVALID, new Object[0]);
            return false;
        }
        try {
            String valueStr = ctx.dataLoader.getUserData(player.getName(), dataKey);
            currentAmount = Double.parseDouble(valueStr);
        }
        catch (Exception e) {
            ctx.text.sendError((Audience)player, Message.REQUIREMENT_DATA_READ_FAIL, new Object[0]);
            return false;
        }
        return currentAmount >= requiredAmount;
    }

    @Override
    public void execute(Context ctx, Panel panel, Player player, String raw, String args) {
        double amount;
        String[] split = args.trim().split("\\s");
        if (split.length != 2) {
            return;
        }
        String dataKey = split[0];
        try {
            amount = Double.parseDouble(split[1]);
        }
        catch (NumberFormatException e) {
            return;
        }
        ctx.dataLoader.doDataMath(player.getName(), dataKey, "-" + amount);
    }
}

