/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.formatter.language;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.formatter.language.Message;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;

public class LanguageManager {
    private final Map<String, String> translations = new HashMap<String, String>();
    private final Context ctx;

    public LanguageManager(Context ctx) {
        this.ctx = ctx;
        this.reloadTranslations();
    }

    public void reloadTranslations() {
        this.translations.clear();
        try {
            YamlConfiguration langFile = YamlConfiguration.loadConfiguration((File)new File(this.ctx.plugin.getDataFolder(), "lang.yml"));
            for (String key : langFile.getKeys(false)) {
                this.translations.put(key.toLowerCase(), langFile.getString(key));
            }
        }
        catch (IllegalArgumentException e) {
            Bukkit.getConsoleSender().sendMessage((Component)Component.text((String)"[CommandPanels] Language file could not be loaded, periods should not be in language keys.", (TextColor)NamedTextColor.RED));
        }
    }

    public String translate(Message message, Object ... args) {
        String normalizedKey = message.name().toLowerCase();
        String translated = this.translations.get(normalizedKey);
        if (translated != null) {
            return this.formatWithPlaceholders(translated, args);
        }
        return message.format(args);
    }

    private String formatWithPlaceholders(String message, Object ... args) {
        String result = message;
        for (int i = 0; i < args.length; ++i) {
            result = result.replace("{" + i + "}", String.valueOf(args[i] != null ? args[i] : "null"));
        }
        return result;
    }
}

