/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.builder.inventory.items.utils;

import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.ItemLore;
import io.papermc.paper.datacomponent.item.TooltipDisplay;
import java.util.List;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.builder.inventory.items.utils.LoreFormatter;
import me.rockyhawk.commandpanels.session.inventory.PanelItem;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class NameHandler {
    private final Context ctx;
    private final LoreFormatter loreFormatter;

    public NameHandler(Context ctx) {
        this.ctx = ctx;
        this.loreFormatter = new LoreFormatter(ctx);
    }

    public ItemStack setName(ItemStack item, PanelItem panelItem, Player player) {
        List<String> lore;
        String name;
        boolean tooltip;
        boolean attributes = Boolean.parseBoolean(this.ctx.text.parseTextToString(player, panelItem.attributes()));
        if (!attributes) {
            TooltipDisplay hideAttributes = (TooltipDisplay)TooltipDisplay.tooltipDisplay().addHiddenComponents(new DataComponentType[]{DataComponentTypes.POTION_CONTENTS, DataComponentTypes.ENCHANTMENTS, DataComponentTypes.ATTRIBUTE_MODIFIERS, DataComponentTypes.DYED_COLOR, DataComponentTypes.TRIM, DataComponentTypes.BANNER_PATTERNS, DataComponentTypes.FIREWORKS, DataComponentTypes.JUKEBOX_PLAYABLE, DataComponentTypes.BUNDLE_CONTENTS, DataComponentTypes.CONTAINER, DataComponentTypes.CONTAINER_LOOT}).build();
            item.setData(DataComponentTypes.TOOLTIP_DISPLAY, (Object)hideAttributes);
        }
        if (!(tooltip = Boolean.parseBoolean(this.ctx.text.parseTextToString(player, panelItem.tooltip())))) {
            TooltipDisplay tooltipHidden = (TooltipDisplay)TooltipDisplay.tooltipDisplay().hideTooltip(true).build();
            item.setData(DataComponentTypes.TOOLTIP_DISPLAY, (Object)tooltipHidden);
        }
        if (!(name = panelItem.displayName()).isEmpty()) {
            item.setData(DataComponentTypes.CUSTOM_NAME, (Object)this.ctx.text.parseTextToComponent(player, name));
        }
        if (!(lore = panelItem.lore()).isEmpty()) {
            List<Component> formattedLore = this.loreFormatter.format(lore, player);
            item.setData(DataComponentTypes.LORE, (Object)ItemLore.lore(formattedLore));
        }
        return item;
    }
}

