/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.session.inventory.generator;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.formatter.language.Message;
import me.rockyhawk.commandpanels.session.inventory.generator.ItemResolver;
import me.rockyhawk.commandpanels.session.inventory.generator.resolvers.ArmorColorResolver;
import me.rockyhawk.commandpanels.session.inventory.generator.resolvers.CustomHeadResolver;
import me.rockyhawk.commandpanels.session.inventory.generator.resolvers.DamageResolver;
import me.rockyhawk.commandpanels.session.inventory.generator.resolvers.DisplayNameResolver;
import me.rockyhawk.commandpanels.session.inventory.generator.resolvers.EnchantmentsResolver;
import me.rockyhawk.commandpanels.session.inventory.generator.resolvers.ItemModelResolver;
import me.rockyhawk.commandpanels.session.inventory.generator.resolvers.LoreResolver;
import me.rockyhawk.commandpanels.session.inventory.generator.resolvers.PotionResolver;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.DoubleChest;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GenerateManager
implements Listener {
    private final Context ctx;
    private final Set<UUID> generatingPlayers = new HashSet<UUID>();
    private final List<ItemResolver> resolvers = List.of(new DisplayNameResolver(), new ItemModelResolver(), new LoreResolver(), new EnchantmentsResolver(), new PotionResolver(), new DamageResolver(), new CustomHeadResolver(), new ArmorColorResolver());

    public GenerateManager(Context ctx) {
        this.ctx = ctx;
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent e) {
        HumanEntity humanEntity = e.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        InventoryHolder holder = e.getInventory().getHolder();
        if (this.isInGenerateMode(player) && (holder instanceof BlockState || holder instanceof DoubleChest)) {
            this.handleInventoryOpen(player, e.getInventory());
            e.setCancelled(true);
        }
    }

    public void startGenerateMode(final Player player) {
        this.generatingPlayers.add(player.getUniqueId());
        this.ctx.text.sendInfo((Audience)player, Message.GENERATE_MODE_ENABLED, new Object[0]);
        new BukkitRunnable(){

            public void run() {
                if (GenerateManager.this.generatingPlayers.remove(player.getUniqueId())) {
                    GenerateManager.this.ctx.text.sendInfo((Audience)player, Message.GENERATE_MODE_EXPIRED, new Object[0]);
                }
            }
        }.runTaskLater((Plugin)this.ctx.plugin, 200L);
    }

    public boolean isInGenerateMode(Player player) {
        return this.generatingPlayers.contains(player.getUniqueId());
    }

    public void handleInventoryOpen(Player player, Inventory inv) {
        if (!this.isInGenerateMode(player)) {
            return;
        }
        this.generatingPlayers.remove(player.getUniqueId());
        String panelName = this.findAvailablePanelName();
        YamlConfiguration yamlData = new YamlConfiguration();
        yamlData.set("title", (Object)("Generated " + panelName));
        yamlData.set("type", (Object)"inventory");
        yamlData.set("rows", (Object)(inv.getSize() / 9));
        LinkedHashMap<String, List<String>> layout = new LinkedHashMap<String, List<String>>();
        LinkedHashMap<String, LinkedHashMap<String, Object>> items = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
        for (int i = 0; i < inv.getSize(); ++i) {
            ItemStack item = inv.getItem(i);
            if (item == null || item.getType() == Material.AIR) continue;
            String key = ("item_" + String.valueOf(item.getType()) + "_" + i).toLowerCase();
            layout.put(String.valueOf(i), Collections.singletonList(key));
            LinkedHashMap<String, Object> itemData = new LinkedHashMap<String, Object>();
            itemData.put("material", item.getType().name());
            itemData.put("stack", item.getAmount());
            for (ItemResolver resolver : this.resolvers) {
                resolver.resolve(item, itemData);
            }
            items.put(key, itemData);
        }
        yamlData.set("layout", layout);
        yamlData.set("items", items);
        try {
            yamlData.save(new File(this.ctx.plugin.folder, panelName + ".yml"));
            this.ctx.fileHandler.reloadPanels();
            this.ctx.text.sendInfo((Audience)player, Message.GENERATE_PANEL_CREATED, new Object[0]);
        }
        catch (IOException e) {
            this.ctx.text.sendError((Audience)player, Message.FILE_SAVE_PANEL_FAIL, new Object[0]);
        }
    }

    private String findAvailablePanelName() {
        for (int index = 1; index < Integer.MAX_VALUE; ++index) {
            String panelName = "panel_" + index;
            File panelFile = new File(this.ctx.plugin.folder, panelName + ".yml");
            if (panelFile.exists()) continue;
            return panelName;
        }
        return "panel_1";
    }
}

