/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.formatter;

import java.util.ArrayList;
import java.util.List;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.formatter.PlaceholderResolver;
import me.rockyhawk.commandpanels.formatter.placeholders.DataPlaceholder;
import me.rockyhawk.commandpanels.formatter.placeholders.RandomPlaceholder;
import me.rockyhawk.commandpanels.formatter.placeholders.SessionDataPlaceholder;
import org.bukkit.OfflinePlayer;

public class Placeholders
extends PlaceholderExpansion {
    private final Context ctx;
    private final List<PlaceholderResolver> resolvers = new ArrayList<PlaceholderResolver>();

    public Placeholders(Context pl) {
        this.ctx = pl;
        this.loadPlaceholders();
    }

    private void loadPlaceholders() {
        this.resolvers.add(new SessionDataPlaceholder());
        this.resolvers.add(new DataPlaceholder());
        this.resolvers.add(new RandomPlaceholder());
    }

    public boolean persist() {
        return true;
    }

    public String getAuthor() {
        return "RockyHawk";
    }

    public String getIdentifier() {
        return "commandpanels";
    }

    public String getVersion() {
        return this.ctx.plugin.getDescription().getVersion();
    }

    public String onRequest(OfflinePlayer player, String params) {
        if (player == null) {
            return "";
        }
        params = PlaceholderAPI.setBracketPlaceholders((OfflinePlayer)player, (String)params);
        for (PlaceholderResolver resolver : this.resolvers) {
            try {
                String value = resolver.resolve(player, params, this.ctx);
                if (value == null) continue;
                return value;
            }
            catch (Exception e) {
                return "unknown";
            }
        }
        return "unknown";
    }
}

