/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.session.inventory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.builder.PanelBuilder;
import me.rockyhawk.commandpanels.builder.inventory.InventoryPanelBuilder;
import me.rockyhawk.commandpanels.interaction.commands.CommandRunner;
import me.rockyhawk.commandpanels.session.ClickActions;
import me.rockyhawk.commandpanels.session.Panel;
import me.rockyhawk.commandpanels.session.floodgate.FloodgatePanel;
import me.rockyhawk.commandpanels.session.inventory.InventoryPanelUpdater;
import me.rockyhawk.commandpanels.session.inventory.PanelItem;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.geysermc.floodgate.api.FloodgateApi;

public class InventoryPanel
extends Panel
implements InventoryHolder {
    private final String rows;
    private final Map<String, PanelItem> items = new HashMap<String, PanelItem>();
    private final Map<String, List<String>> slots = new HashMap<String, List<String>>();
    private final ClickActions outside;
    private final String floodgate;
    private final String updateDelay;

    public InventoryPanel(String name, YamlConfiguration config) {
        super(name, config);
        ConfigurationSection itemsSection;
        this.rows = config.getString("rows", "1");
        this.floodgate = config.getString("floodgate", "");
        this.updateDelay = config.getString("update-delay", "20");
        this.outside = new ClickActions(config.getStringList("outside.requirements"), config.getStringList("outside.commands"), config.getStringList("outside.fail"));
        ConfigurationSection slotSection = config.getConfigurationSection("layout");
        if (slotSection != null) {
            for (String key : slotSection.getKeys(false)) {
                this.slots.put(key, slotSection.getStringList(key));
            }
        }
        if ((itemsSection = config.getConfigurationSection("items")) != null) {
            for (String key : itemsSection.getKeys(false)) {
                ConfigurationSection itemSection = itemsSection.getConfigurationSection(key);
                if (itemSection == null) continue;
                PanelItem item = PanelItem.fromSection(key, itemSection);
                this.items.put(itemSection.getName(), item);
            }
        }
    }

    @Override
    public void open(Context ctx, Player player, boolean isNewPanelSession) {
        Panel panel = ctx.plugin.panels.get(this.floodgate);
        if (Bukkit.getPluginManager().getPlugin("floodgate") != null && panel instanceof FloodgatePanel) {
            FloodgatePanel floodgatePanel = (FloodgatePanel)panel;
            if (FloodgateApi.getInstance().isFloodgatePlayer(player.getUniqueId())) {
                floodgatePanel.open(ctx, player, true);
                return;
            }
        }
        if (isNewPanelSession) {
            if (!this.canOpen(player, ctx)) {
                return;
            }
            this.updatePanelData(ctx, player);
            CommandRunner runner = new CommandRunner(ctx);
            runner.runCommands(this, player, this.getCommands());
        }
        InventoryPanelBuilder builder = new InventoryPanelBuilder(ctx, player);
        ((PanelBuilder)builder).open(this);
        if (isNewPanelSession) {
            InventoryPanelUpdater updater = new InventoryPanelUpdater();
            updater.start(ctx, player, this);
        }
    }

    public String getRows() {
        return this.rows;
    }

    public Map<String, PanelItem> getItems() {
        return this.items;
    }

    public Map<String, List<String>> getSlots() {
        return this.slots;
    }

    public String getUpdateDelay() {
        return this.updateDelay;
    }

    public ClickActions getOutsideCommands() {
        return this.outside;
    }

    public Inventory getInventory() {
        return null;
    }
}

