/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.builder.floodgate;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.builder.floodgate.FloodgatePanelBuilder;
import me.rockyhawk.commandpanels.builder.logic.ConditionNode;
import me.rockyhawk.commandpanels.builder.logic.ConditionParser;
import me.rockyhawk.commandpanels.formatter.language.Message;
import me.rockyhawk.commandpanels.interaction.commands.CommandRunner;
import me.rockyhawk.commandpanels.interaction.commands.RequirementRunner;
import me.rockyhawk.commandpanels.session.floodgate.FloodgateComponent;
import me.rockyhawk.commandpanels.session.floodgate.FloodgatePanel;
import me.rockyhawk.commandpanels.session.floodgate.components.FloodgateDropdown;
import me.rockyhawk.commandpanels.session.floodgate.components.FloodgateInput;
import me.rockyhawk.commandpanels.session.floodgate.components.FloodgateLabel;
import me.rockyhawk.commandpanels.session.floodgate.components.FloodgateSlider;
import me.rockyhawk.commandpanels.session.floodgate.components.FloodgateStepSlider;
import me.rockyhawk.commandpanels.session.floodgate.components.FloodgateToggle;
import net.kyori.adventure.audience.Audience;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.geysermc.cumulus.form.CustomForm;
import org.geysermc.cumulus.response.CustomFormResponse;
import org.geysermc.floodgate.api.FloodgateApi;

public class CustomForm {
    protected final Context ctx;
    protected final FloodgatePanelBuilder builder;
    private final Pattern NUMBER_PATTERN = Pattern.compile("^-?\\d+(\\.\\d+)?$");

    public CustomForm(Context ctx, FloodgatePanelBuilder builder) {
        this.ctx = ctx;
        this.builder = builder;
    }

    public void sendForm(FloodgatePanel panel) {
        Player player = this.builder.getPlayer();
        CustomForm.Builder form = (CustomForm.Builder)org.geysermc.cumulus.form.CustomForm.builder().title(this.ctx.text.parseTextToString(player, panel.getTitle()));
        ArrayList<FloodgateComponent> inputOrder = new ArrayList<FloodgateComponent>();
        block8: for (int i = 0; i < panel.getOrder().size(); ++i) {
            if (!panel.getOrder().containsKey(String.valueOf(i))) {
                this.ctx.text.sendError((Audience)player, Message.PANEL_LAYOUT_NUMBER_MISSING, new Object[0]);
                return;
            }
            List<String> componentIds = panel.getOrder().get(String.valueOf(i));
            for (String key : componentIds) {
                FloodgateComponent floodgateComponent;
                ConditionNode conditionNode;
                FloodgateComponent comp = panel.getComponents().get(key);
                if (comp == null || !comp.getConditions().trim().isEmpty() && !(conditionNode = new ConditionParser().parse(comp.getConditions())).evaluate(player, panel, this.ctx)) continue;
                Objects.requireNonNull(comp);
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FloodgateLabel.class, FloodgateInput.class, FloodgateSlider.class, FloodgateDropdown.class, FloodgateToggle.class, FloodgateStepSlider.class}, (Object)floodgateComponent, n)) {
                    case 0: {
                        FloodgateLabel input = (FloodgateLabel)floodgateComponent;
                        form.label(this.parseText(input.getName().replaceAll("\\\\n", "\n")));
                        inputOrder.add(input);
                        continue block8;
                    }
                    case 1: {
                        FloodgateInput input = (FloodgateInput)floodgateComponent;
                        form.input(this.parseText(input.getName()), this.parseText(input.getPlaceholder()), this.parseText(input.getDefault()));
                        inputOrder.add(input);
                        continue block8;
                    }
                    case 2: {
                        FloodgateSlider slider = (FloodgateSlider)floodgateComponent;
                        form.slider(this.parseText(slider.getName()), this.parseFloat(slider.getMinimum()), this.parseFloat(slider.getMaximum()), (float)this.parseInt(slider.getStep()), this.parseFloat(slider.getDefault()));
                        inputOrder.add(slider);
                        continue block8;
                    }
                    case 3: {
                        FloodgateDropdown dropdown = (FloodgateDropdown)floodgateComponent;
                        ArrayList<String> parsedOptions = new ArrayList<String>();
                        for (String opt : dropdown.getOptions()) {
                            parsedOptions.add(this.parseText(opt));
                        }
                        form.dropdown(this.parseText(dropdown.getName()), parsedOptions, this.parseInt(dropdown.getDefault()));
                        inputOrder.add(dropdown);
                        continue block8;
                    }
                    case 4: {
                        FloodgateToggle toggle = (FloodgateToggle)floodgateComponent;
                        form.toggle(this.parseText(toggle.getName()), this.parseBoolean(toggle.getDefault()));
                        inputOrder.add(toggle);
                        continue block8;
                    }
                    case 5: {
                        FloodgateStepSlider stepSlider = (FloodgateStepSlider)floodgateComponent;
                        ArrayList<String> parsedSteps = new ArrayList<String>();
                        for (String step : stepSlider.getSteps()) {
                            parsedSteps.add(this.parseText(step));
                        }
                        form.stepSlider(this.parseText(stepSlider.getName()), parsedSteps, this.parseInt(stepSlider.getDefault()));
                        inputOrder.add(stepSlider);
                        continue block8;
                    }
                    default: {
                        continue block8;
                    }
                }
            }
        }
        form.validResultHandler(arg_0 -> this.lambda$sendForm$0(inputOrder, panel, player, arg_0));
        FloodgateApi.getInstance().sendForm(player.getUniqueId(), form.build());
    }

    private void createSessionData(String key, String output) {
        this.builder.getPlayer().getPersistentDataContainer().set(new NamespacedKey((Plugin)this.ctx.plugin, key), PersistentDataType.STRING, (Object)output);
    }

    private String parseText(String raw) {
        return this.ctx.text.parseTextToString(this.builder.getPlayer(), raw);
    }

    private int parseInt(String raw) {
        String parsed = this.parseText(raw);
        if (this.NUMBER_PATTERN.matcher(parsed).matches()) {
            try {
                return Integer.parseInt(parsed);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    private float parseFloat(String raw) {
        String parsed = this.parseText(raw);
        if (this.NUMBER_PATTERN.matcher(parsed).matches()) {
            try {
                return Float.parseFloat(parsed);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.0f;
    }

    private boolean parseBoolean(String raw) {
        String parsed = this.parseText(raw);
        return Boolean.parseBoolean(parsed);
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$sendForm$0(List inputOrder, FloodgatePanel panel, Player player, CustomFormResponse response) {
        index = 0;
        while (response.hasNext()) {
            rawValue = response.next();
            comp = (FloodgateComponent)inputOrder.get(index);
            value = String.valueOf(rawValue);
            if (!(comp instanceof FloodgateDropdown)) ** GOTO lbl-1000
            dropdown = (FloodgateDropdown)comp;
            if (rawValue instanceof Integer) {
                value = dropdown.getOptions().get((Integer)rawValue);
            } else if (comp instanceof FloodgateStepSlider) {
                slider = (FloodgateStepSlider)comp;
                if (rawValue instanceof Integer) {
                    value = slider.getSteps().get((Integer)rawValue);
                }
            }
            this.createSessionData(comp.getId(), value);
            ++index;
        }
        for (FloodgateComponent comp : inputOrder) {
            commands = new CommandRunner(this.ctx);
            requirements = new RequirementRunner(this.ctx);
            if (!requirements.processRequirements(panel, player, comp.getClickActions().requirements())) {
                commands.runCommands(panel, player, comp.getClickActions().fail());
                return;
            }
            commands.runCommands(panel, player, comp.getClickActions().commands());
        }
    }
}

