/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.interaction.commands.tags;

import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.formatter.language.Message;
import me.rockyhawk.commandpanels.interaction.commands.CommandTagResolver;
import me.rockyhawk.commandpanels.session.Panel;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class TeleportTag
implements CommandTagResolver {
    @Override
    public boolean isCorrectTag(String tag) {
        return tag.startsWith("[teleport]");
    }

    @Override
    public void handle(Context ctx, Panel panel, Player player, String raw, String command) {
        String[] args = ctx.text.parseTextToString(player, command).split("\\s+");
        float yaw = 0.0f;
        float pitch = 0.0f;
        Player teleportedPlayer = player;
        World teleportedWorld = player.getWorld();
        try {
            float x = Float.parseFloat(args[0]);
            float y = Float.parseFloat(args[1]);
            float z = Float.parseFloat(args[2]);
            for (String val : args) {
                if (val.startsWith("world=")) {
                    teleportedWorld = Bukkit.getWorld((String)val.substring(6));
                    continue;
                }
                if (val.startsWith("yaw=")) {
                    yaw = Float.parseFloat(val.substring(4));
                    continue;
                }
                if (val.startsWith("pitch=")) {
                    pitch = Float.parseFloat(val.substring(6));
                    continue;
                }
                if (!val.startsWith("player=")) continue;
                teleportedPlayer = Bukkit.getPlayer((String)val.substring(7));
            }
            Location teleportLocation = new Location(teleportedWorld, (double)x, (double)y, (double)z, yaw, pitch);
            if (teleportedPlayer != null) {
                teleportedPlayer.teleport(teleportLocation);
            }
        }
        catch (Exception ex) {
            ctx.text.sendError((Audience)player, Message.TELEPORT_ERROR, new Object[0]);
        }
    }
}

