/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.formatter.language;

import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.formatter.language.LanguageManager;
import me.rockyhawk.commandpanels.formatter.language.Message;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.intellij.lang.annotations.Subst;
import org.jetbrains.annotations.NotNull;

public class TextFormatter {
    public final LanguageManager lang;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private final Pattern MOJANG_HEX = Pattern.compile("(?i)[&\u00a7]x[&\u00a7]([0-9a-f])[&\u00a7]([0-9a-f])[&\u00a7]([0-9a-f])[&\u00a7]([0-9a-f])[&\u00a7]([0-9a-f])[&\u00a7]([0-9a-f])");
    private final Pattern LEGACY_HASH_HEX = Pattern.compile("(?i)[&\u00a7]#([0-9a-f]{6})");
    private final Pattern LEGACY_SIMPLE = Pattern.compile("(?i)[&\u00a7]([0-9a-fk-or])");
    private final Map<Character, String> COLOR_MAP = Map.ofEntries(Map.entry(Character.valueOf('0'), "black"), Map.entry(Character.valueOf('1'), "dark_blue"), Map.entry(Character.valueOf('2'), "dark_green"), Map.entry(Character.valueOf('3'), "dark_aqua"), Map.entry(Character.valueOf('4'), "dark_red"), Map.entry(Character.valueOf('5'), "dark_purple"), Map.entry(Character.valueOf('6'), "gold"), Map.entry(Character.valueOf('7'), "gray"), Map.entry(Character.valueOf('8'), "dark_gray"), Map.entry(Character.valueOf('9'), "blue"), Map.entry(Character.valueOf('a'), "green"), Map.entry(Character.valueOf('b'), "aqua"), Map.entry(Character.valueOf('c'), "red"), Map.entry(Character.valueOf('d'), "light_purple"), Map.entry(Character.valueOf('e'), "yellow"), Map.entry(Character.valueOf('f'), "white"), Map.entry(Character.valueOf('k'), "obfuscated"), Map.entry(Character.valueOf('l'), "bold"), Map.entry(Character.valueOf('m'), "strikethrough"), Map.entry(Character.valueOf('n'), "underlined"), Map.entry(Character.valueOf('o'), "italic"), Map.entry(Character.valueOf('r'), "reset"));

    public TextFormatter(Context ctx) {
        this.lang = new LanguageManager(ctx);
    }

    public TextComponent getPrefix() {
        String translatedPrefix = this.lang.translate(Message.PREFIX, new Object[0]) + " ";
        if (Objects.equals(translatedPrefix, "[CommandPanels] ")) {
            return (TextComponent)((TextComponent)Component.text((String)"[", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"CommandPanels", (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)"] ", (TextColor)NamedTextColor.GOLD));
        }
        return (TextComponent)this.deserializeAppropriately(translatedPrefix);
    }

    private Component buildLocalizedComponent(String translatedMessage, NamedTextColor defaultColor) {
        if (translatedMessage == null || translatedMessage.isEmpty()) {
            return Component.empty();
        }
        Component parsed = this.deserializeAppropriately(translatedMessage);
        return ((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)defaultColor)).append(parsed)).build();
    }

    public void sendInfo(Audience audience, Message message, Object ... args) {
        String translated = this.lang.translate(message, args);
        Component comp = this.buildLocalizedComponent(translated, NamedTextColor.WHITE);
        audience.sendMessage(this.getPrefix().append(comp));
    }

    public void sendWarn(Audience audience, Message message, Object ... args) {
        String translated = this.lang.translate(message, args);
        Component comp = this.buildLocalizedComponent(translated, NamedTextColor.YELLOW);
        audience.sendMessage(this.getPrefix().append(comp));
    }

    public void sendError(Audience audience, Message message, Object ... args) {
        String translated = this.lang.translate(message, args);
        Component comp = this.buildLocalizedComponent(translated, NamedTextColor.RED);
        audience.sendMessage(this.getPrefix().append(comp));
    }

    public void sendHelp(Audience audience, Message command, Message description, Object ... args) {
        String translatedCommand = this.lang.translate(command, args);
        String translatedDescription = this.lang.translate(description, args);
        Component cmdComp = this.buildLocalizedComponent(translatedCommand, NamedTextColor.GOLD);
        Component descComp = this.buildLocalizedComponent(translatedDescription, NamedTextColor.WHITE);
        Component space = Component.text((String)" ").color((TextColor)NamedTextColor.WHITE);
        BuildableComponent helpComp = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(cmdComp)).append(space)).append(descComp)).build();
        audience.sendMessage((Component)helpComp);
    }

    @NotNull
    public Component parseTextToComponent(Player player, String input) {
        if (input == null || input.isEmpty()) {
            return Component.empty();
        }
        input = this.applyPlaceholders(player, input);
        return this.deserializeAppropriately(input);
    }

    @Subst(value="")
    @NotNull
    public String parseTextToString(Player player, String input) {
        Component component = this.parseTextToComponent(player, input);
        return LegacyComponentSerializer.builder().hexColors().useUnusualXRepeatedCharacterHexFormat().build().serialize(component);
    }

    public String applyPlaceholders(Player player, String input) {
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)player.getUniqueId());
            return PlaceholderAPI.setPlaceholders((OfflinePlayer)offlinePlayer, (String)input);
        }
        return input;
    }

    private Component deserializeAppropriately(String input) {
        try {
            String normalized = this.convertLegacyToMiniMessage(input);
            Component mmComponent = this.miniMessage.deserialize((Object)normalized);
            if (mmComponent.decoration(TextDecoration.ITALIC) == TextDecoration.State.NOT_SET) {
                mmComponent = mmComponent.decoration(TextDecoration.ITALIC, false);
            }
            return mmComponent;
        }
        catch (Exception e) {
            return Component.text((String)input).decoration(TextDecoration.ITALIC, false);
        }
    }

    private String convertLegacyToMiniMessage(String input) {
        if (input == null) {
            return "";
        }
        String processed = input;
        Matcher mojangMatcher = this.MOJANG_HEX.matcher(processed);
        StringBuilder mmSB = new StringBuilder();
        while (mojangMatcher.find()) {
            String hex = (mojangMatcher.group(1) + mojangMatcher.group(2) + mojangMatcher.group(3) + mojangMatcher.group(4) + mojangMatcher.group(5) + mojangMatcher.group(6)).toLowerCase();
            mojangMatcher.appendReplacement(mmSB, Matcher.quoteReplacement("<#" + hex + ">"));
        }
        mojangMatcher.appendTail(mmSB);
        processed = mmSB.toString();
        Matcher hexMatcher = this.LEGACY_HASH_HEX.matcher(processed);
        StringBuilder sb1 = new StringBuilder();
        while (hexMatcher.find()) {
            String hex = hexMatcher.group(1).toLowerCase();
            hexMatcher.appendReplacement(sb1, Matcher.quoteReplacement("<#" + hex + ">"));
        }
        hexMatcher.appendTail(sb1);
        processed = sb1.toString();
        Matcher simpleMatcher = this.LEGACY_SIMPLE.matcher(processed);
        StringBuilder sb2 = new StringBuilder();
        while (simpleMatcher.find()) {
            char code = Character.toLowerCase(simpleMatcher.group(1).charAt(0));
            String replacement = this.COLOR_MAP.getOrDefault(Character.valueOf(code), "reset");
            simpleMatcher.appendReplacement(sb2, Matcher.quoteReplacement("<" + replacement + ">"));
        }
        simpleMatcher.appendTail(sb2);
        return sb2.toString();
    }
}

