/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.builder.dialog;

import io.papermc.paper.registry.data.dialog.ActionButton;
import io.papermc.paper.registry.data.dialog.action.DialogAction;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.builder.dialog.DialogPanelBuilder;
import me.rockyhawk.commandpanels.builder.logic.ConditionNode;
import me.rockyhawk.commandpanels.builder.logic.ConditionParser;
import me.rockyhawk.commandpanels.interaction.commands.CommandRunner;
import me.rockyhawk.commandpanels.interaction.commands.RequirementRunner;
import me.rockyhawk.commandpanels.session.ClickActions;
import me.rockyhawk.commandpanels.session.dialog.DialogComponent;
import me.rockyhawk.commandpanels.session.dialog.DialogPanel;
import me.rockyhawk.commandpanels.session.dialog.components.DialogButton;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickCallback;
import net.kyori.adventure.text.event.ClickEvent;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ActionBuilder
implements Listener {
    private final Context ctx;
    private final DialogPanelBuilder builder;

    public ActionBuilder(Context ctx, DialogPanelBuilder builder) {
        this.ctx = ctx;
        this.builder = builder;
    }

    public ActionButton buildButton(DialogButton button, DialogPanel panel) {
        ConditionNode conditionNode;
        Player player = this.builder.getPlayer();
        if (!button.getConditions().trim().isEmpty() && !(conditionNode = new ConditionParser().parse(button.getConditions())).evaluate(player, this.ctx)) {
            return null;
        }
        Component name = this.ctx.text.parseTextToComponent(player, button.getName());
        Component tooltip = this.ctx.text.parseTextToComponent(player, button.getTooltip());
        DialogAction.CustomClickAction action = DialogAction.customClick((options, audience) -> {
            ClickActions actions = button.getClickActions();
            CommandRunner commands = new CommandRunner(this.ctx);
            RequirementRunner requirements = new RequirementRunner(this.ctx);
            for (DialogComponent comp : panel.getComponents().values()) {
                String id = comp.getId();
                String text = options.getText(id);
                Boolean bool = options.getBoolean(id);
                Float number = options.getFloat(id);
                if (text != null) {
                    player.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.ctx.plugin, id), PersistentDataType.STRING, (Object)text);
                    continue;
                }
                if (number != null) {
                    player.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.ctx.plugin, id), PersistentDataType.STRING, (Object)String.valueOf(number));
                    continue;
                }
                if (bool == null) continue;
                player.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.ctx.plugin, id), PersistentDataType.STRING, (Object)String.valueOf(bool));
            }
            if (!requirements.processRequirements(panel, player, actions.requirements())) {
                commands.runCommands(panel, player, actions.fail());
            } else {
                commands.runCommands(panel, player, actions.commands());
            }
        }, (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().build()));
        if (!button.getClipboard().isEmpty()) {
            action = DialogAction.staticAction((ClickEvent)ClickEvent.copyToClipboard((String)this.ctx.text.parseTextToString(player, button.getClipboard())));
        }
        if (!button.getUrl().isEmpty()) {
            action = DialogAction.staticAction((ClickEvent)ClickEvent.openUrl((String)this.ctx.text.parseTextToString(player, button.getUrl())));
        }
        return ActionButton.builder((Component)name).tooltip(tooltip).action((DialogAction)action).width(this.builder.parseInt(button.getWidth())).build();
    }
}

