/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.session.inventory.generator.resolvers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import me.rockyhawk.commandpanels.session.inventory.generator.ItemResolver;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;

public class CustomHeadResolver
implements ItemResolver {
    @Override
    public void resolve(ItemStack item, Map<String, Object> itemData) {
        if (item.getType() != Material.PLAYER_HEAD) {
            return;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (!(itemMeta instanceof SkullMeta)) {
            return;
        }
        SkullMeta meta = (SkullMeta)itemMeta;
        PlayerProfile profile = meta.getOwnerProfile();
        if (profile == null) {
            return;
        }
        PlayerTextures textures = profile.getTextures();
        URL skinUrl = textures.getSkin();
        if (skinUrl != null) {
            JsonObject skin = new JsonObject();
            JsonObject texturesObj = new JsonObject();
            JsonObject skinObj = new JsonObject();
            skinObj.addProperty("url", skinUrl.toString());
            texturesObj.add("SKIN", (JsonElement)skinObj);
            skin.add("textures", (JsonElement)texturesObj);
            String json = skin.toString();
            String base64 = Base64.getEncoder().encodeToString(json.getBytes(StandardCharsets.UTF_8));
            itemData.put("material", "[head] " + base64);
        }
    }
}

